/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gradle.cache.internal.filelock.LockInfo;

public class LockInfoSerializer {
    public byte getVersion() {
        return 3;
    }

    public void write(DataOutput dataOutput, LockInfo lockInfo) throws IOException {
        dataOutput.writeInt(lockInfo.port);
        dataOutput.writeLong(lockInfo.lockId);
        dataOutput.writeUTF(this.trimIfNecessary(lockInfo.pid));
        dataOutput.writeUTF(this.trimIfNecessary(lockInfo.operation));
    }

    public LockInfo read(DataInput dataInput) throws IOException {
        LockInfo lockInfo = new LockInfo();
        lockInfo.port = dataInput.readInt();
        lockInfo.lockId = dataInput.readLong();
        lockInfo.pid = dataInput.readUTF();
        lockInfo.operation = dataInput.readUTF();
        return lockInfo;
    }

    private String trimIfNecessary(String string) {
        if (string.length() > 340) {
            return string.substring(0, 340);
        }
        return string;
    }
}

