/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.internal.locklistener.FileLockPacketType;

public class FileLockPacketPayload {
    private static final ImmutableList<FileLockPacketType> TYPES = ImmutableList.copyOf(FileLockPacketType.values());
    private final long lockId;
    private final FileLockPacketType type;

    private FileLockPacketPayload(long l2, FileLockPacketType fileLockPacketType) {
        this.lockId = l2;
        this.type = fileLockPacketType;
    }

    public long getLockId() {
        return this.lockId;
    }

    public FileLockPacketType getType() {
        return this.type;
    }

    public static byte[] encode(long l2, FileLockPacketType fileLockPacketType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeLong(l2);
            dataOutputStream.writeByte(fileLockPacketType.ordinal());
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to encode lockId " + l2 + " and type " + (Object)((Object)fileLockPacketType), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static FileLockPacketPayload decode(byte[] byArray, int n2) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            byte by2 = dataInputStream.readByte();
            if (by2 != 1) {
                throw new IllegalArgumentException(String.format("Unexpected protocol version %s received in lock contention notification message", by2));
            }
            long l2 = dataInputStream.readLong();
            FileLockPacketType fileLockPacketType = FileLockPacketPayload.readType(dataInputStream, n2);
            return new FileLockPacketPayload(l2, fileLockPacketType);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static FileLockPacketType readType(DataInputStream dataInputStream, int n2) throws IOException {
        if (n2 < 10) {
            return FileLockPacketType.UNKNOWN;
        }
        try {
            byte by2 = dataInputStream.readByte();
            if (by2 < TYPES.size()) {
                return (FileLockPacketType)((Object)TYPES.get(by2));
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return FileLockPacketType.UNKNOWN;
    }
}

