/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.gradle.cache.PersistentCache;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.io.IoConsumer;

public class DirectoryBuildCache
implements Closeable,
BuildCacheTempFileStore,
LocalBuildCache {
    private final PersistentCache persistentCache;
    private final BuildCacheTempFileStore tempFileStore;
    private final FileAccessTracker fileAccessTracker;
    private final String failedFileSuffix;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public DirectoryBuildCache(PersistentCache persistentCache, FileAccessTracker fileAccessTracker, String string3) {
        this.persistentCache = persistentCache;
        this.tempFileStore = new DefaultBuildCacheTempFileStore((string, string2) -> {
            try {
                return Files.createTempFile(persistentCache.getBaseDir().toPath(), string, string2, new FileAttribute[0]).toFile();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
        this.fileAccessTracker = fileAccessTracker;
        this.failedFileSuffix = string3;
    }

    public boolean load(HashCode hashCode, IoConsumer<InputStream> ioConsumer) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.loadLocally(hashCode, file -> {
            try {
                Closer closer = Closer.create();
                FileInputStream fileInputStream = closer.register(new FileInputStream((File)file));
                try {
                    ioConsumer.accept(fileInputStream);
                    atomicBoolean.set(true);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
        return atomicBoolean.get();
    }

    public void loadLocally(HashCode hashCode, Consumer<? super File> consumer) {
        this.persistentCache.withFileLock(() -> {
            this.lock.readLock().lock();
            try {
                this.loadInsideLock(hashCode, consumer);
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    private void loadInsideLock(HashCode hashCode, Consumer<? super File> consumer) {
        File file = this.getCacheEntryFile(hashCode);
        if (!file.exists()) {
            return;
        }
        this.fileAccessTracker.markAccessed(file);
        try {
            consumer.accept(file);
        }
        catch (Exception exception) {
            File file2 = new File(file.getAbsolutePath() + this.failedFileSuffix);
            FileUtils.deleteQuietly(file2);
            file.renameTo(file2);
            throw UncheckedException.throwAsUncheckedException(exception);
        }
    }

    public void store(HashCode hashCode, IoConsumer<OutputStream> ioConsumer) {
        this.tempFileStore.withTempFile(hashCode, file -> {
            try (Closer closer = Closer.create();){
                ioConsumer.accept(closer.register(new FileOutputStream((File)file)));
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException(iOException);
            }
            this.storeLocally(hashCode, (File)file);
        });
    }

    public void storeLocally(HashCode hashCode, File file) {
        this.persistentCache.withFileLock(() -> {
            this.lock.writeLock().lock();
            try {
                this.storeInsideLock(hashCode, file);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private void storeInsideLock(HashCode hashCode, File file) {
        File file2 = this.getCacheEntryFile(hashCode);
        try {
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(String.format("Couldn't move cache entry '%s' into local cache: %s", hashCode, iOException), iOException);
        }
        this.fileAccessTracker.markAccessed(file2);
    }

    @Override
    public void withTempFile(HashCode hashCode, Consumer<? super File> consumer) {
        this.persistentCache.withFileLock(() -> this.tempFileStore.withTempFile(hashCode, consumer));
    }

    @Override
    public void close() {
        this.persistentCache.close();
    }

    private File getCacheEntryFile(HashCode hashCode) {
        return new File(this.persistentCache.getBaseDir(), hashCode.toString());
    }
}

