/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.hashing.ConfigurableNormalizer;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.EmptyCurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public abstract class AbstractFingerprintingStrategy
implements FingerprintingStrategy {
    private final String identifier;
    private final CurrentFileCollectionFingerprint emptyFingerprint;
    private final HashCode configurationHash;

    public AbstractFingerprintingStrategy(String string, ConfigurableNormalizer configurableNormalizer) {
        this.identifier = string;
        this.emptyFingerprint = new EmptyCurrentFileCollectionFingerprint(string);
        Hasher hasher = Hashing.newHasher();
        hasher.putString(this.getClass().getName());
        configurableNormalizer.appendConfigurationToHasher(hasher);
        this.configurationHash = hasher.hash();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CurrentFileCollectionFingerprint getEmptyFingerprint() {
        return this.emptyFingerprint;
    }

    protected HashCode getNormalizedContentHash(FileSystemLocationSnapshot fileSystemLocationSnapshot, FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        try {
            return fileSystemLocationSnapshotHasher.hash(fileSystemLocationSnapshot);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(AbstractFingerprintingStrategy.failedToNormalize(fileSystemLocationSnapshot), iOException);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw new UncheckedIOException(AbstractFingerprintingStrategy.failedToNormalize(fileSystemLocationSnapshot), uncheckedIOException.getCause());
        }
    }

    private static String failedToNormalize(FileSystemLocationSnapshot fileSystemLocationSnapshot) {
        return String.format("Failed to normalize content of '%s'.", fileSystemLocationSnapshot.getAbsolutePath());
    }

    @Override
    public HashCode getConfigurationHash() {
        return this.configurationHash;
    }
}

