/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.snapshot.impl.FilteredTrackingMerkleDirectorySnapshotBuilder;

public class DirectorySnapshotter {
    private static final EnumSet<FileVisitOption> DONT_FOLLOW_SYMLINKS = EnumSet.noneOf(FileVisitOption.class);
    private static final SymbolicLinkMapping EMPTY_SYMBOLIC_LINK_MAPPING = new SymbolicLinkMapping(){

        @Override
        public String remapAbsolutePath(Path path) {
            return path.toString();
        }

        @Override
        public SymbolicLinkMapping withNewMapping(String string, String string2, RelativePathTracker relativePathTracker) {
            return new DefaultSymbolicLinkMapping(string, string2, relativePathTracker.getSegments());
        }

        @Override
        public Iterable<String> getRemappedSegments(Iterable<String> iterable) {
            return iterable;
        }
    };
    private final FileHasher hasher;
    private final Interner<String> stringInterner;
    private final DefaultExcludes defaultExcludes;
    private final DirectorySnapshotterStatistics.Collector collector;

    public DirectorySnapshotter(FileHasher fileHasher, Interner<String> interner, Collection<String> collection, DirectorySnapshotterStatistics.Collector collector) {
        this.hasher = fileHasher;
        this.stringInterner = interner;
        this.defaultExcludes = new DefaultExcludes(collection);
        this.collector = collector;
    }

    public FileSystemLocationSnapshot snapshot(String string, SnapshottingFilter.DirectoryWalkerPredicate directoryWalkerPredicate, Map<String, ? extends FileSystemLocationSnapshot> map, Consumer<FileSystemLocationSnapshot> consumer) {
        try {
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            Path path = Paths.get(string, new String[0]);
            PathVisitor pathVisitor = new PathVisitor(directoryWalkerPredicate, atomicBoolean, this.hasher, this.stringInterner, this.defaultExcludes, this.collector, EMPTY_SYMBOLIC_LINK_MAPPING, map, consumer);
            Files.walkFileTree(path, DONT_FOLLOW_SYMLINKS, Integer.MAX_VALUE, pathVisitor);
            FileSystemLocationSnapshot fileSystemLocationSnapshot = pathVisitor.getResult();
            if (!atomicBoolean.get()) {
                consumer.accept(fileSystemLocationSnapshot);
            }
            return fileSystemLocationSnapshot;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", string), iOException);
        }
    }

    static class DefaultExcludes {
        private final ImmutableSet<String> excludeFileNames;
        private final ImmutableSet<String> excludedDirNames;
        private final Predicate<String> excludedFileNameSpec;

        public DefaultExcludes(Collection<String> collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<Predicate<String>> arrayList3 = new ArrayList<Predicate<String>>();
            for (String string2 : collection) {
                if (string2.startsWith("**/")) {
                    string2 = string2.substring(3);
                }
                int n2 = string2.length();
                if (string2.endsWith("/**")) {
                    arrayList2.add(string2.substring(0, n2 - 3));
                    continue;
                }
                int n3 = string2.indexOf(42);
                if (n3 == -1) {
                    arrayList.add(string2);
                    continue;
                }
                StartMatcher startMatcher = n3 == 0 ? string -> true : new StartMatcher(string2.substring(0, n3));
                EndMatcher endMatcher = n3 == n2 - 1 ? string -> true : new EndMatcher(string2.substring(n3 + 1, n2));
                arrayList3.add(startMatcher.and(endMatcher));
            }
            this.excludeFileNames = ImmutableSet.copyOf(arrayList);
            this.excludedFileNameSpec = arrayList3.stream().reduce(string -> false, Predicate::or);
            this.excludedDirNames = ImmutableSet.copyOf(arrayList2);
        }

        public boolean excludeDir(String string) {
            return this.excludedDirNames.contains(string);
        }

        public boolean excludeFile(String string) {
            return this.excludeFileNames.contains(string) || this.excludedFileNameSpec.test(string);
        }

        private static class StartMatcher
        implements Predicate<String> {
            private final String start;

            public StartMatcher(String string) {
                this.start = string;
            }

            @Override
            public boolean test(String string) {
                return string.startsWith(this.start);
            }
        }

        private static class EndMatcher
        implements Predicate<String> {
            private final String end;

            public EndMatcher(String string) {
                this.end = string;
            }

            @Override
            public boolean test(String string) {
                return string.endsWith(this.end);
            }
        }
    }

    private static class PathVisitor
    extends DirectorySnapshotterStatistics.CollectingFileVisitor {
        private final RelativePathTracker pathTracker = new RelativePathTracker();
        private final FilteredTrackingMerkleDirectorySnapshotBuilder builder;
        private final SnapshottingFilter.DirectoryWalkerPredicate predicate;
        private final AtomicBoolean hasBeenFiltered;
        private final FileHasher hasher;
        private final Interner<String> stringInterner;
        private final DefaultExcludes defaultExcludes;
        private final SymbolicLinkMapping symbolicLinkMapping;
        private final Deque<String> parentDirectories = new ArrayDeque<String>();
        private final Set<FileSystemLocationSnapshot> filteredDirectorySnapshots = new HashSet<FileSystemLocationSnapshot>();
        private final ImmutableMap<String, ? extends FileSystemLocationSnapshot> previouslyKnownSnapshots;
        private final Consumer<FileSystemLocationSnapshot> unfilteredSnapshotRecorder;

        public PathVisitor(SnapshottingFilter.DirectoryWalkerPredicate directoryWalkerPredicate, AtomicBoolean atomicBoolean, FileHasher fileHasher, Interner<String> interner, DefaultExcludes defaultExcludes, DirectorySnapshotterStatistics.Collector collector, SymbolicLinkMapping symbolicLinkMapping, Map<String, ? extends FileSystemLocationSnapshot> map, Consumer<FileSystemLocationSnapshot> consumer) {
            super(collector);
            this.builder = FilteredTrackingMerkleDirectorySnapshotBuilder.sortingRequired(this::recordUnfilteredSnapshot);
            this.predicate = directoryWalkerPredicate;
            this.hasBeenFiltered = atomicBoolean;
            this.hasher = fileHasher;
            this.stringInterner = interner;
            this.defaultExcludes = defaultExcludes;
            this.symbolicLinkMapping = symbolicLinkMapping;
            this.previouslyKnownSnapshots = ImmutableMap.copyOf(map);
            this.unfilteredSnapshotRecorder = consumer;
        }

        private void recordUnfilteredSnapshot(FileSystemLocationSnapshot fileSystemLocationSnapshot) {
            if (fileSystemLocationSnapshot.getType() != FileType.Directory || !this.filteredDirectorySnapshots.contains(fileSystemLocationSnapshot)) {
                this.unfilteredSnapshotRecorder.accept(fileSystemLocationSnapshot);
            }
        }

        @Override
        protected FileVisitResult doPreVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
            String string = this.getInternedFileName(path);
            this.pathTracker.enter(string);
            if (this.shouldVisitDirectory(path, string)) {
                String string2 = this.intern(this.symbolicLinkMapping.remapAbsolutePath(path));
                if (this.predicate == null) {
                    FileSystemLocationSnapshot fileSystemLocationSnapshot = this.previouslyKnownSnapshots.get(string2);
                    if (fileSystemLocationSnapshot instanceof DirectorySnapshot) {
                        this.builder.visitDirectory((DirectorySnapshot)fileSystemLocationSnapshot);
                        this.pathTracker.leave();
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (fileSystemLocationSnapshot != null) {
                        throw new IllegalStateException("Expected a previously known directory snapshot at " + string2 + " but got " + fileSystemLocationSnapshot);
                    }
                }
                this.builder.enterDirectory(FileMetadata.AccessType.DIRECT, string2, string, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                this.parentDirectories.addFirst(path.toString());
                return FileVisitResult.CONTINUE;
            }
            this.pathTracker.leave();
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        protected FileVisitResult doPostVisitDirectory(Path path, IOException iOException) {
            this.pathTracker.leave();
            if (PathVisitor.isNotFileSystemLoopException(iOException)) {
                throw new UncheckedIOException(String.format("Could not read directory path '%s'.", path), iOException);
            }
            boolean bl2 = this.builder.isCurrentLevelUnfiltered();
            FileSystemLocationSnapshot fileSystemLocationSnapshot = this.builder.leaveDirectory();
            if (!bl2) {
                this.filteredDirectorySnapshots.add(fileSystemLocationSnapshot);
            }
            this.parentDirectories.removeFirst();
            return FileVisitResult.CONTINUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FileVisitResult doVisitFile(Path path, BasicFileAttributes basicFileAttributes) {
            String string = this.getInternedFileName(path);
            this.pathTracker.enter(string);
            try {
                Object object;
                if (basicFileAttributes.isSymbolicLink()) {
                    object = PathVisitor.readAttributesOfSymlinkTarget(path, basicFileAttributes);
                    if (object.isDirectory()) {
                        AtomicBoolean atomicBoolean = new AtomicBoolean();
                        DirectorySnapshot directorySnapshot = this.followSymlink(path, string, atomicBoolean);
                        if (directorySnapshot != null) {
                            DirectorySnapshot directorySnapshot2 = new DirectorySnapshot(directorySnapshot.getAbsolutePath(), string, FileMetadata.AccessType.VIA_SYMLINK, directorySnapshot.getHash(), directorySnapshot.getChildren());
                            this.builder.visitDirectory(directorySnapshot2);
                            boolean bl2 = atomicBoolean.get();
                            if (bl2) {
                                this.filteredDirectorySnapshots.add(directorySnapshot2);
                                this.builder.markCurrentLevelAsFiltered();
                                this.hasBeenFiltered.set(true);
                            }
                        }
                    } else {
                        this.visitResolvedFile(path, (BasicFileAttributes)object, FileMetadata.AccessType.VIA_SYMLINK);
                    }
                } else {
                    this.visitResolvedFile(path, basicFileAttributes, FileMetadata.AccessType.DIRECT);
                }
                object = FileVisitResult.CONTINUE;
                return object;
            }
            finally {
                this.pathTracker.leave();
            }
        }

        private DirectorySnapshot followSymlink(Path path, String string, AtomicBoolean atomicBoolean) {
            try {
                Path path2 = path.toRealPath(new LinkOption[0]);
                String string2 = path2.toString();
                if (!this.introducesCycle(string2) && this.shouldVisitDirectory(path2, string)) {
                    PathVisitor pathVisitor = new PathVisitor(this.predicate, atomicBoolean, this.hasher, this.stringInterner, this.defaultExcludes, this.collector, this.symbolicLinkMapping.withNewMapping(path.toString(), string2, this.pathTracker), this.previouslyKnownSnapshots, this.unfilteredSnapshotRecorder);
                    Files.walkFileTree(path2, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, pathVisitor);
                    return (DirectorySnapshot)pathVisitor.getResult();
                }
                return null;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(String.format("Could not list contents of directory '%s'.", path), iOException);
            }
        }

        private boolean introducesCycle(String string) {
            return this.parentDirectories.contains(string);
        }

        private void visitResolvedFile(Path path, BasicFileAttributes basicFileAttributes, FileMetadata.AccessType accessType) {
            String string = this.intern(path.getFileName().toString());
            if (this.shouldVisitFile(path, string)) {
                this.builder.visitLeafElement(this.snapshotFile(path, string, basicFileAttributes, accessType));
            }
        }

        private boolean shouldVisitDirectory(Path path, String string) {
            return this.pathTracker.isRoot() || this.shouldVisit(path, string, true);
        }

        private boolean shouldVisitFile(Path path, String string) {
            return this.shouldVisit(path, string, false);
        }

        private static BasicFileAttributes readAttributesOfSymlinkTarget(Path path, BasicFileAttributes basicFileAttributes) {
            try {
                return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException iOException) {
                return basicFileAttributes;
            }
        }

        private FileSystemLeafSnapshot snapshotFile(Path path, String string, BasicFileAttributes basicFileAttributes, FileMetadata.AccessType accessType) {
            String string2 = this.intern(this.symbolicLinkMapping.remapAbsolutePath(path));
            FileSystemLocationSnapshot fileSystemLocationSnapshot = this.previouslyKnownSnapshots.get(string2);
            if (fileSystemLocationSnapshot != null) {
                if (!(fileSystemLocationSnapshot instanceof FileSystemLeafSnapshot)) {
                    throw new IllegalStateException("Expected a previously known leaf snapshot at " + string2 + ", but found " + fileSystemLocationSnapshot);
                }
                return (FileSystemLeafSnapshot)fileSystemLocationSnapshot;
            }
            if (basicFileAttributes.isSymbolicLink()) {
                return new MissingFileSnapshot(string2, string, accessType);
            }
            if (!basicFileAttributes.isRegularFile()) {
                throw new UncheckedIOException(new IOException(String.format("Cannot snapshot %s: not a regular file", string2)));
            }
            long l2 = basicFileAttributes.lastModifiedTime().toMillis();
            long l3 = basicFileAttributes.size();
            FileMetadata fileMetadata = DefaultFileMetadata.file(l2, l3, accessType);
            HashCode hashCode = this.hasher.hash(path.toFile(), l3, l2);
            return new RegularFileSnapshot(string2, string, hashCode, fileMetadata);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FileVisitResult doVisitFileFailed(Path path, IOException iOException) {
            String string = this.getInternedFileName(path);
            this.pathTracker.enter(string);
            try {
                boolean bl2;
                if (PathVisitor.isNotFileSystemLoopException(iOException) && this.shouldVisit(path, string, bl2 = Files.isDirectory(path, new LinkOption[0]))) {
                    throw new UncheckedIOException(iOException);
                }
                FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                return fileVisitResult;
            }
            finally {
                this.pathTracker.leave();
            }
        }

        private static boolean isNotFileSystemLoopException(IOException iOException) {
            return iOException != null && !(iOException instanceof FileSystemLoopException);
        }

        private String intern(String string) {
            return this.stringInterner.intern(string);
        }

        private boolean shouldVisit(Path path, String string, boolean bl2) {
            if (bl2 ? this.defaultExcludes.excludeDir(string) : this.defaultExcludes.excludeFile(string)) {
                return false;
            }
            if (this.predicate == null) {
                return true;
            }
            boolean bl3 = this.predicate.test(path, string, bl2, this.symbolicLinkMapping.getRemappedSegments(this.pathTracker.getSegments()));
            if (!bl3) {
                this.builder.markCurrentLevelAsFiltered();
                this.hasBeenFiltered.set(true);
            }
            return bl3;
        }

        private String getInternedFileName(Path path) {
            Path path2 = path.getFileName();
            return path2 == null ? "" : this.intern(path2.toString());
        }

        public FileSystemLocationSnapshot getResult() {
            return this.builder.getResult();
        }
    }

    private static interface SymbolicLinkMapping {
        public String remapAbsolutePath(Path var1);

        public SymbolicLinkMapping withNewMapping(String var1, String var2, RelativePathTracker var3);

        public Iterable<String> getRemappedSegments(Iterable<String> var1);
    }

    private static class DefaultSymbolicLinkMapping
    implements SymbolicLinkMapping {
        private final String sourcePath;
        private final String targetPath;
        private final Iterable<String> prefixRelativePath;

        public DefaultSymbolicLinkMapping(String string, String string2, Iterable<String> iterable) {
            this.sourcePath = string;
            this.targetPath = string2;
            this.prefixRelativePath = iterable;
        }

        @Override
        public String remapAbsolutePath(Path path) {
            return this.remapAbsolutePath(path.toString());
        }

        public String remapAbsolutePath(String string) {
            if (string.equals(this.targetPath)) {
                return this.sourcePath;
            }
            if (string.startsWith(this.targetPath) && string.charAt(this.targetPath.length()) == File.separatorChar) {
                return this.sourcePath + File.separatorChar + string.substring(this.targetPath.length() + 1);
            }
            throw new IllegalArgumentException("Cannot remap path '" + string + "' which does not have '" + this.targetPath + "' as a prefix");
        }

        @Override
        public SymbolicLinkMapping withNewMapping(String string, String string2, RelativePathTracker relativePathTracker) {
            return new DefaultSymbolicLinkMapping(this.remapAbsolutePath(string), string2, this.getRemappedSegments(relativePathTracker.getSegments()));
        }

        @Override
        public Iterable<String> getRemappedSegments(Iterable<String> iterable) {
            return Iterables.concat(this.prefixRelativePath, iterable);
        }
    }
}

