/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.RestrictionType;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RestrictionTagParser {
    private final List<String> vehicleTypes;
    private final BooleanEncodedValue turnRestrictionEnc;

    public RestrictionTagParser(List<String> vehicleTypes, BooleanEncodedValue turnRestrictionEnc) {
        this.vehicleTypes = vehicleTypes;
        this.turnRestrictionEnc = turnRestrictionEnc;
    }

    public BooleanEncodedValue getTurnRestrictionEnc() {
        return this.turnRestrictionEnc;
    }

    public Result parseRestrictionTags(Map<String, Object> tags) throws OSMRestrictionException {
        List exceptVehicles;
        String restriction = (String)tags.get("restriction");
        List limitedRestrictions = tags.entrySet().stream().filter(t -> ((String)t.getKey()).startsWith("restriction:")).filter(e -> !"give_way".equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        boolean hasGiveWay = tags.values().stream().anyMatch("give_way"::equals);
        List list = exceptVehicles = tags.containsKey("except") ? Arrays.stream(((String)tags.get("except")).split(";")).map(String::trim).collect(Collectors.toList()) : Collections.emptyList();
        if (restriction != null) {
            if (!limitedRestrictions.isEmpty()) {
                throw new OSMRestrictionException("has a 'restriction' tag, but also 'restriction:' tags");
            }
            if (!Collections.disjoint(this.vehicleTypes, exceptVehicles)) {
                return null;
            }
            return RestrictionTagParser.buildResult(restriction);
        }
        if (limitedRestrictions.isEmpty()) {
            if (!hasGiveWay) {
                throw new OSMRestrictionException("neither has a 'restriction' nor 'restriction:' tags");
            }
            throw OSMRestrictionException.withoutWarning();
        }
        if (!exceptVehicles.isEmpty() && limitedRestrictions.stream().noneMatch(r -> r.startsWith("restriction:conditional"))) {
            throw new OSMRestrictionException("has an 'except', but no 'restriction' or 'restriction:conditional' tag");
        }
        Set restrictions = limitedRestrictions.stream().filter(r -> !r.contains("conditional")).filter(r -> this.vehicleTypes.contains(r.replace("restriction:", "").trim())).map(r -> (String)tags.get(r)).collect(Collectors.toSet());
        if (restrictions.size() > 1) {
            throw new OSMRestrictionException("contains multiple different restriction values: '" + restrictions + "'");
        }
        if (restrictions.isEmpty()) {
            return null;
        }
        return RestrictionTagParser.buildResult((String)restrictions.iterator().next());
    }

    private static Result buildResult(String restriction) throws OSMRestrictionException {
        return new Result(RestrictionTagParser.parseRestrictionValue(restriction), restriction);
    }

    private static RestrictionType parseRestrictionValue(String restriction) throws OSMRestrictionException {
        switch (restriction) {
            case "no_left_turn": 
            case "no_right_turn": 
            case "no_straight_on": 
            case "no_u_turn": 
            case "no_entry": 
            case "no_exit": {
                return RestrictionType.NO;
            }
            case "only_left_turn": 
            case "only_right_turn": 
            case "only_straight_on": 
            case "only_u_turn": {
                return RestrictionType.ONLY;
            }
            case "no_right_turn_on_red": 
            case "no_left_turn_on_red": {
                throw OSMRestrictionException.withoutWarning();
            }
        }
        throw new OSMRestrictionException("uses unknown restriction value: '" + restriction + "'");
    }

    public static class Result {
        private final RestrictionType restrictionType;
        private final String restriction;

        public Result(RestrictionType restrictionType, String restriction) {
            this.restrictionType = restrictionType;
            this.restriction = restriction;
        }

        public RestrictionType getRestrictionType() {
            return this.restrictionType;
        }

        public String getRestriction() {
            return this.restriction;
        }
    }
}

