/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.Arrays;

public class DijkstraOneToMany
extends AbstractRoutingAlgorithm {
    private static final int EMPTY_PARENT = -1;
    private static final int NOT_FOUND = -1;
    private final IntArrayListWithCap changedNodes;
    protected double[] weights;
    private int[] parents;
    private int[] edgeIds;
    private IntFloatBinaryHeap heap;
    private int visitedNodes;
    private boolean doClear = true;
    private int endNode;
    private int currNode;
    private int fromNode;
    private int to;
    private double weightLimit = Double.MAX_VALUE;

    public DijkstraOneToMany(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        this.parents = new int[graph.getNodes()];
        Arrays.fill(this.parents, -1);
        this.edgeIds = new int[graph.getNodes()];
        Arrays.fill(this.edgeIds, -1);
        this.weights = new double[graph.getNodes()];
        Arrays.fill(this.weights, Double.MAX_VALUE);
        this.heap = new IntFloatBinaryHeap(1000);
        this.changedNodes = new IntArrayListWithCap();
    }

    @Override
    public Path calcPath(int from, int to) {
        int edge;
        this.fromNode = from;
        this.endNode = this.findEndNode(from, to);
        if (this.endNode < 0 || this.isWeightLimitExceeded()) {
            Path path = this.createEmptyPath();
            path.setFromNode(this.fromNode);
            path.setEndNode(this.endNode);
            return path;
        }
        Path path = new Path(this.graph);
        int node = this.endNode;
        while (EdgeIterator.Edge.isValid(edge = this.edgeIds[node])) {
            EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(edge, node);
            path.addDistance(edgeState.getDistance());
            path.addTime(this.weighting.calcEdgeMillis(edgeState, false));
            path.addEdge(edge);
            node = this.parents[node];
        }
        ArrayUtil.reverse(path.getEdges());
        path.setFromNode(this.fromNode);
        path.setEndNode(this.endNode);
        path.setFound(true);
        path.setWeight(this.weights[this.endNode]);
        return path;
    }

    public DijkstraOneToMany clear() {
        this.doClear = true;
        return this;
    }

    public double getWeight(int endNode) {
        return this.weights[endNode];
    }

    public int findEndNode(int from, int to) {
        if (this.weights.length < 2) {
            return -1;
        }
        this.to = to;
        if (this.doClear) {
            this.doClear = false;
            int vn = this.changedNodes.size();
            for (int i = 0; i < vn; ++i) {
                int n = this.changedNodes.get(i);
                this.weights[n] = Double.MAX_VALUE;
                this.parents[n] = -1;
                this.edgeIds[n] = -1;
            }
            this.heap.clear();
            this.changedNodes.elementsCount = 0;
            this.currNode = from;
            if (!this.traversalMode.isEdgeBased()) {
                this.weights[this.currNode] = 0.0;
                this.changedNodes.add(this.currNode);
            }
        } else {
            int parentNode = this.parents[to];
            if (parentNode != -1 && this.weights[to] <= this.weights[this.currNode]) {
                return to;
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded() || this.isTimeoutExceeded()) {
                return -1;
            }
            this.currNode = this.heap.poll();
        }
        this.visitedNodes = 0;
        if (this.finished()) {
            if (this.heap.isEmpty()) {
                this.doClear = true;
            }
            return this.currNode;
        }
        while (true) {
            ++this.visitedNodes;
            EdgeIterator iter = this.edgeExplorer.setBaseNode(this.currNode);
            while (iter.next()) {
                double tmpWeight;
                int adjNode = iter.getAdjNode();
                int prevEdgeId = this.edgeIds[adjNode];
                if (!this.accept(iter, prevEdgeId) || Double.isInfinite(tmpWeight = GHUtility.calcWeightWithTurnWeight(this.weighting, iter, false, prevEdgeId) + this.weights[this.currNode])) continue;
                double w = this.weights[adjNode];
                if (w == Double.MAX_VALUE) {
                    this.parents[adjNode] = this.currNode;
                    this.weights[adjNode] = tmpWeight;
                    this.heap.insert(tmpWeight, adjNode);
                    this.changedNodes.add(adjNode);
                    this.edgeIds[adjNode] = iter.getEdge();
                    continue;
                }
                if (!(w > tmpWeight)) continue;
                this.parents[adjNode] = this.currNode;
                this.weights[adjNode] = tmpWeight;
                this.heap.update(tmpWeight, adjNode);
                this.changedNodes.add(adjNode);
                this.edgeIds[adjNode] = iter.getEdge();
            }
            if (this.heap.isEmpty() || this.isMaxVisitedNodesExceeded() || this.isWeightLimitExceeded() || this.isTimeoutExceeded()) {
                return -1;
            }
            this.currNode = this.heap.peekElement();
            if (this.finished()) {
                return this.currNode;
            }
            this.heap.poll();
        }
    }

    private boolean finished() {
        return this.currNode == this.to;
    }

    public void setWeightLimit(double weightLimit) {
        this.weightLimit = weightLimit;
    }

    protected boolean isWeightLimitExceeded() {
        return this.weights[this.currNode] > this.weightLimit;
    }

    public void close() {
        this.weights = null;
        this.parents = null;
        this.edgeIds = null;
        this.heap = null;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    @Override
    public String getName() {
        return "dijkstra_one_to_many";
    }

    public String getMemoryUsageAsString() {
        long len = this.weights.length;
        return (16L * len + (long)this.changedNodes.getCapacity() * 4L + this.heap.getCapacity() * 8L) / 0x100000L + "MB";
    }

    private static class IntArrayListWithCap
    extends IntArrayList {
        public int getCapacity() {
            return this.buffer.length;
        }
    }
}

