/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.GHUtility;

public class CHPreparationGraph {
    private final int nodes;
    private final int edges;
    private final boolean edgeBased;
    private final TurnCostFunction turnCostFunction;
    private PrepareEdge[] prepareEdgesOut;
    private PrepareEdge[] prepareEdgesIn;
    private IntArrayList shortcutsByPrepareEdges;
    private int[] degrees;
    private IntSet neighborSet;
    private OrigGraph origGraph;
    private OrigGraph.Builder origGraphBuilder;
    private int nextShortcutId;
    private boolean ready;

    public static CHPreparationGraph nodeBased(int nodes, int edges) {
        return new CHPreparationGraph(nodes, edges, false, (in, via, out) -> 0.0);
    }

    public static CHPreparationGraph edgeBased(int nodes, int edges, TurnCostFunction turnCostFunction) {
        return new CHPreparationGraph(nodes, edges, true, turnCostFunction);
    }

    private CHPreparationGraph(int nodes, int edges, boolean edgeBased, TurnCostFunction turnCostFunction) {
        this.turnCostFunction = turnCostFunction;
        this.nodes = nodes;
        this.edges = edges;
        this.edgeBased = edgeBased;
        this.prepareEdgesOut = new PrepareEdge[nodes];
        this.prepareEdgesIn = new PrepareEdge[nodes];
        this.shortcutsByPrepareEdges = new IntArrayList();
        this.degrees = new int[nodes];
        this.origGraphBuilder = edgeBased ? new OrigGraph.Builder() : null;
        this.neighborSet = new IntScatterSet();
        this.nextShortcutId = edges;
    }

    public static void buildFromGraph(CHPreparationGraph prepareGraph, Graph graph, Weighting weighting) {
        if (graph.getNodes() != prepareGraph.getNodes()) {
            throw new IllegalArgumentException("Cannot initialize from given graph. The number of nodes does not match: " + graph.getNodes() + " vs. " + prepareGraph.getNodes());
        }
        if (graph.getEdges() != prepareGraph.getOriginalEdges()) {
            throw new IllegalArgumentException("Cannot initialize from given graph. The number of edges does not match: " + graph.getEdges() + " vs. " + prepareGraph.getOriginalEdges());
        }
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            double weightFwd = weighting.calcEdgeWeight(iter, false);
            double weightBwd = weighting.calcEdgeWeight(iter, true);
            prepareGraph.addEdge(iter.getBaseNode(), iter.getAdjNode(), iter.getEdge(), weightFwd, weightBwd);
        }
        prepareGraph.prepareForContraction();
    }

    public static TurnCostFunction buildTurnCostFunctionFromTurnCostStorage(Graph graph, Weighting weighting) {
        return weighting::calcTurnWeight;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getOriginalEdges() {
        return this.edges;
    }

    public int getDegree(int node) {
        return this.degrees[node];
    }

    public void addEdge(int from, int to, int edge, double weightFwd, double weightBwd) {
        this.checkNotReady();
        if (from == to) {
            throw new IllegalArgumentException("Loop edges are no longer supported since #2862");
        }
        boolean fwd = Double.isFinite(weightFwd);
        boolean bwd = Double.isFinite(weightBwd);
        if (!fwd && !bwd) {
            return;
        }
        PrepareBaseEdge prepareEdge = new PrepareBaseEdge(edge, from, to, (float)weightFwd, (float)weightBwd);
        if (fwd) {
            this.addOutEdge(from, prepareEdge);
            this.addInEdge(to, prepareEdge);
        }
        if (bwd && from != to) {
            this.addOutEdge(to, prepareEdge);
            this.addInEdge(from, prepareEdge);
        }
        if (this.edgeBased) {
            this.origGraphBuilder.addEdge(from, to, edge, fwd, bwd);
        }
    }

    public int addShortcut(int from, int to, int origEdgeKeyFirst, int origEdgeKeyLast, int skipped1, int skipped2, double weight, int origEdgeCount) {
        this.checkReady();
        PrepareShortcut prepareEdge = this.edgeBased ? new EdgeBasedPrepareShortcut(this.nextShortcutId, from, to, origEdgeKeyFirst, origEdgeKeyLast, weight, skipped1, skipped2, origEdgeCount) : new PrepareShortcut(this.nextShortcutId, from, to, weight, skipped1, skipped2, origEdgeCount);
        this.addOutEdge(from, prepareEdge);
        if (from != to) {
            this.addInEdge(to, prepareEdge);
        }
        return this.nextShortcutId++;
    }

    public void prepareForContraction() {
        this.checkNotReady();
        this.origGraph = this.edgeBased ? this.origGraphBuilder.build() : null;
        this.origGraphBuilder = null;
        this.ready = true;
    }

    public void setShortcutForPrepareEdge(int prepareEdge, int shortcut) {
        int index = prepareEdge - this.edges;
        if (index >= this.shortcutsByPrepareEdges.size()) {
            this.shortcutsByPrepareEdges.resize(index + 1);
        }
        this.shortcutsByPrepareEdges.set(index, shortcut);
    }

    public int getShortcutForPrepareEdge(int prepareEdge) {
        if (prepareEdge < this.edges) {
            return prepareEdge;
        }
        int index = prepareEdge - this.edges;
        return this.shortcutsByPrepareEdges.get(index);
    }

    public PrepareGraphEdgeExplorer createOutEdgeExplorer() {
        this.checkReady();
        return new PrepareGraphEdgeExplorerImpl(this.prepareEdgesOut, false);
    }

    public PrepareGraphEdgeExplorer createInEdgeExplorer() {
        this.checkReady();
        return new PrepareGraphEdgeExplorerImpl(this.prepareEdgesIn, true);
    }

    public PrepareGraphOrigEdgeExplorer createOutOrigEdgeExplorer() {
        this.checkReady();
        if (!this.edgeBased) {
            throw new IllegalStateException("orig out explorer is not available for node-based graph");
        }
        return this.origGraph.createOutOrigEdgeExplorer();
    }

    public PrepareGraphOrigEdgeExplorer createInOrigEdgeExplorer() {
        this.checkReady();
        if (!this.edgeBased) {
            throw new IllegalStateException("orig in explorer is not available for node-based graph");
        }
        return this.origGraph.createInOrigEdgeExplorer();
    }

    public double getTurnWeight(int inEdgeKey, int viaNode, int outEdgeKey) {
        return this.turnCostFunction.getTurnWeight(GHUtility.getEdgeFromEdgeKey(inEdgeKey), viaNode, GHUtility.getEdgeFromEdgeKey(outEdgeKey));
    }

    public IntContainer disconnect(int node) {
        this.checkReady();
        this.neighborSet.clear();
        PrepareEdge currOut = this.prepareEdgesOut[node];
        while (currOut != null) {
            int adjNode = currOut.getNodeB();
            if (adjNode == node) {
                adjNode = currOut.getNodeA();
            }
            if (adjNode == node) {
                currOut = currOut.getNextOut(node);
                continue;
            }
            this.removeInEdge(adjNode, currOut);
            this.neighborSet.add(adjNode);
            currOut = currOut.getNextOut(node);
        }
        PrepareEdge currIn = this.prepareEdgesIn[node];
        while (currIn != null) {
            int adjNode = currIn.getNodeB();
            if (adjNode == node) {
                adjNode = currIn.getNodeA();
            }
            if (adjNode == node) {
                currIn = currIn.getNextIn(node);
                continue;
            }
            this.removeOutEdge(adjNode, currIn);
            this.neighborSet.add(adjNode);
            currIn = currIn.getNextIn(node);
        }
        this.prepareEdgesOut[node] = null;
        this.prepareEdgesIn[node] = null;
        this.degrees[node] = 0;
        return this.neighborSet;
    }

    private void removeOutEdge(int node, PrepareEdge prepareEdge) {
        PrepareEdge prevOut = null;
        for (PrepareEdge currOut = this.prepareEdgesOut[node]; currOut != null; currOut = currOut.getNextOut(node)) {
            if (currOut == prepareEdge) {
                if (prevOut == null) {
                    this.prepareEdgesOut[node] = currOut.getNextOut(node);
                } else {
                    prevOut.setNextOut(node, currOut.getNextOut(node));
                }
                int n = node;
                this.degrees[n] = this.degrees[n] - 1;
                continue;
            }
            prevOut = currOut;
        }
    }

    private void removeInEdge(int node, PrepareEdge prepareEdge) {
        PrepareEdge prevIn = null;
        for (PrepareEdge currIn = this.prepareEdgesIn[node]; currIn != null; currIn = currIn.getNextIn(node)) {
            if (currIn == prepareEdge) {
                if (prevIn == null) {
                    this.prepareEdgesIn[node] = currIn.getNextIn(node);
                } else {
                    prevIn.setNextIn(node, currIn.getNextIn(node));
                }
                int n = node;
                this.degrees[n] = this.degrees[n] - 1;
                continue;
            }
            prevIn = currIn;
        }
    }

    public void close() {
        this.checkReady();
        this.prepareEdgesOut = null;
        this.prepareEdgesIn = null;
        this.shortcutsByPrepareEdges = null;
        this.degrees = null;
        this.neighborSet = null;
        if (this.edgeBased) {
            this.origGraph = null;
        }
    }

    private void addOutEdge(int node, PrepareEdge prepareEdge) {
        prepareEdge.setNextOut(node, this.prepareEdgesOut[node]);
        this.prepareEdgesOut[node] = prepareEdge;
        int n = node;
        this.degrees[n] = this.degrees[n] + 1;
    }

    private void addInEdge(int node, PrepareEdge prepareEdge) {
        prepareEdge.setNextIn(node, this.prepareEdgesIn[node]);
        this.prepareEdgesIn[node] = prepareEdge;
        int n = node;
        this.degrees[n] = this.degrees[n] + 1;
    }

    private void checkReady() {
        if (!this.ready) {
            throw new IllegalStateException("You need to call prepareForContraction() before calling this method");
        }
    }

    private void checkNotReady() {
        if (this.ready) {
            throw new IllegalStateException("You cannot call this method after calling prepareForContraction()");
        }
    }

    private static void sortAndTrim(IntArrayList arr, int[] sortOrder) {
        arr.buffer = CHPreparationGraph.applySortOrder(sortOrder, arr.buffer);
        arr.elementsCount = arr.buffer.length;
    }

    private static int[] applySortOrder(int[] sortOrder, int[] arr) {
        if (sortOrder.length > arr.length) {
            throw new IllegalArgumentException("sort order must not be shorter than array");
        }
        int[] result = new int[sortOrder.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arr[sortOrder[i]];
        }
        return result;
    }

    private static class OrigEdgeIteratorImpl
    implements PrepareGraphOrigEdgeExplorer,
    PrepareGraphOrigEdgeIterator {
        private final OrigGraph graph;
        private final boolean reverse;
        private int node;
        private int endEdge;
        private int index;

        public OrigEdgeIteratorImpl(OrigGraph graph, boolean reverse) {
            this.graph = graph;
            this.reverse = reverse;
        }

        @Override
        public PrepareGraphOrigEdgeIterator setBaseNode(int node) {
            this.node = node;
            this.index = this.graph.firstEdgesByNode.get(node) - 1;
            this.endEdge = this.graph.firstEdgesByNode.get(node + 1);
            return this;
        }

        @Override
        public boolean next() {
            do {
                ++this.index;
                if (this.index < this.endEdge) continue;
                return false;
            } while (!this.hasAccess());
            return true;
        }

        @Override
        public int getBaseNode() {
            return this.node;
        }

        @Override
        public int getAdjNode() {
            return this.graph.adjNodes.get(this.index);
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            return this.graph.keysAndFlags.get(this.index) >>> 2;
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.getOrigEdgeKeyFirst();
        }

        private boolean hasAccess() {
            int e = this.graph.keysAndFlags.get(this.index);
            if (this.reverse) {
                return (e & 1) == 1;
            }
            return (e & 2) == 2;
        }

        public String toString() {
            return this.getBaseNode() + "-" + this.getAdjNode() + "(" + this.getOrigEdgeKeyFirst() + ")";
        }
    }

    static class OrigGraph {
        private final IntArrayList adjNodes;
        private final IntArrayList keysAndFlags;
        private final IntArrayList firstEdgesByNode;

        private OrigGraph(IntArrayList firstEdgesByNode, IntArrayList adjNodes, IntArrayList keysAndFlags) {
            this.firstEdgesByNode = firstEdgesByNode;
            this.adjNodes = adjNodes;
            this.keysAndFlags = keysAndFlags;
        }

        PrepareGraphOrigEdgeExplorer createOutOrigEdgeExplorer() {
            return new OrigEdgeIteratorImpl(this, false);
        }

        PrepareGraphOrigEdgeExplorer createInOrigEdgeExplorer() {
            return new OrigEdgeIteratorImpl(this, true);
        }

        static class Builder {
            private final IntArrayList fromNodes = new IntArrayList();
            private final IntArrayList toNodes = new IntArrayList();
            private final IntArrayList keysAndFlags = new IntArrayList();
            private int maxFrom = -1;
            private int maxTo = -1;

            Builder() {
            }

            void addEdge(int from, int to, int edge, boolean fwd, boolean bwd) {
                this.fromNodes.add(from);
                this.toNodes.add(to);
                this.keysAndFlags.add(Builder.getKeyWithFlags(GHUtility.createEdgeKey(edge, false), fwd, bwd));
                this.maxFrom = Math.max(this.maxFrom, from);
                this.maxTo = Math.max(this.maxTo, to);
                this.fromNodes.add(to);
                this.toNodes.add(from);
                this.keysAndFlags.add(Builder.getKeyWithFlags(GHUtility.createEdgeKey(edge, true), bwd, fwd));
                this.maxFrom = Math.max(this.maxFrom, to);
                this.maxTo = Math.max(this.maxTo, from);
            }

            OrigGraph build() {
                int[] sortOrder = IndirectSort.mergesort((int)0, (int)this.fromNodes.elementsCount, (IndirectComparator)new IndirectComparator.AscendingIntComparator(this.fromNodes.buffer));
                CHPreparationGraph.sortAndTrim(this.fromNodes, sortOrder);
                CHPreparationGraph.sortAndTrim(this.toNodes, sortOrder);
                CHPreparationGraph.sortAndTrim(this.keysAndFlags, sortOrder);
                return new OrigGraph(this.buildFirstEdgesByNode(), this.toNodes, this.keysAndFlags);
            }

            private static int getKeyWithFlags(int key, boolean fwd, boolean bwd) {
                if (key > 0x3FFFFFFF) {
                    throw new IllegalArgumentException("Maximum edge key exceeded: " + key + ", max: " + 0x3FFFFFFF);
                }
                key <<= 1;
                if (fwd) {
                    ++key;
                }
                key <<= 1;
                if (bwd) {
                    ++key;
                }
                return key;
            }

            private IntArrayList buildFirstEdgesByNode() {
                int numFroms = this.maxFrom + 1;
                int numEdges = this.fromNodes.size();
                IntArrayList firstEdgesByNode = ArrayUtil.zero(numFroms + 1);
                if (numFroms == 0) {
                    firstEdgesByNode.set(0, numEdges);
                    return firstEdgesByNode;
                }
                int edgeIndex = 0;
                for (int from = 0; from < numFroms; ++from) {
                    while (edgeIndex < numEdges && this.fromNodes.get(edgeIndex) < from) {
                        ++edgeIndex;
                    }
                    firstEdgesByNode.set(from, edgeIndex);
                }
                firstEdgesByNode.set(numFroms, numEdges);
                return firstEdgesByNode;
            }
        }
    }

    private static class EdgeBasedPrepareShortcut
    extends PrepareShortcut {
        private final int origEdgeKeyFirst;
        private final int origEdgeKeyLast;

        public EdgeBasedPrepareShortcut(int prepareEdge, int from, int to, int origEdgeKeyFirst, int origEdgeKeyLast, double weight, int skipped1, int skipped2, int origEdgeCount) {
            super(prepareEdge, from, to, weight, skipped1, skipped2, origEdgeCount);
            this.origEdgeKeyFirst = origEdgeKeyFirst;
            this.origEdgeKeyLast = origEdgeKeyLast;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            return this.origEdgeKeyFirst;
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            return this.origEdgeKeyFirst;
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            return this.origEdgeKeyLast;
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            return this.origEdgeKeyLast;
        }

        @Override
        public String toString() {
            return this.getNodeA() + "-" + this.getNodeB() + " (" + this.origEdgeKeyFirst + ", " + this.origEdgeKeyLast + ") " + this.getWeightAB();
        }
    }

    private static class PrepareShortcut
    implements PrepareEdge {
        private final int prepareEdge;
        private final int from;
        private final int to;
        private double weight;
        private int skipped1;
        private int skipped2;
        private int origEdgeCount;
        private PrepareEdge nextOut;
        private PrepareEdge nextIn;

        private PrepareShortcut(int prepareEdge, int from, int to, double weight, int skipped1, int skipped2, int origEdgeCount) {
            this.prepareEdge = prepareEdge;
            this.from = from;
            this.to = to;
            assert (Double.isFinite(weight));
            this.weight = weight;
            this.skipped1 = skipped1;
            this.skipped2 = skipped2;
            this.origEdgeCount = origEdgeCount;
        }

        @Override
        public boolean isShortcut() {
            return true;
        }

        @Override
        public int getPrepareEdge() {
            return this.prepareEdge;
        }

        @Override
        public int getNodeA() {
            return this.from;
        }

        @Override
        public int getNodeB() {
            return this.to;
        }

        @Override
        public double getWeightAB() {
            return this.weight;
        }

        @Override
        public double getWeightBA() {
            return this.weight;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getSkipped1() {
            return this.skipped1;
        }

        @Override
        public int getSkipped2() {
            return this.skipped2;
        }

        @Override
        public int getOrigEdgeCount() {
            return this.origEdgeCount;
        }

        @Override
        public void setSkipped1(int skipped1) {
            this.skipped1 = skipped1;
        }

        @Override
        public void setSkipped2(int skipped2) {
            this.skipped2 = skipped2;
        }

        @Override
        public void setWeight(double weight) {
            this.weight = weight;
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            this.origEdgeCount = origEdgeCount;
        }

        @Override
        public PrepareEdge getNextOut(int base) {
            return this.nextOut;
        }

        @Override
        public void setNextOut(int base, PrepareEdge prepareEdge) {
            this.nextOut = prepareEdge;
        }

        @Override
        public PrepareEdge getNextIn(int base) {
            return this.nextIn;
        }

        @Override
        public void setNextIn(int base, PrepareEdge prepareEdge) {
            this.nextIn = prepareEdge;
        }

        public String toString() {
            return this.from + "-" + this.to + " " + this.weight;
        }
    }

    public static class PrepareBaseEdge
    implements PrepareEdge {
        private final int prepareEdge;
        private final int nodeA;
        private final int nodeB;
        private final float weightAB;
        private final float weightBA;
        private PrepareEdge nextOutA;
        private PrepareEdge nextOutB;
        private PrepareEdge nextInA;
        private PrepareEdge nextInB;

        public PrepareBaseEdge(int prepareEdge, int nodeA, int nodeB, float weightAB, float weightBA) {
            this.prepareEdge = prepareEdge;
            this.nodeA = nodeA;
            this.nodeB = nodeB;
            this.weightAB = weightAB;
            this.weightBA = weightBA;
        }

        @Override
        public boolean isShortcut() {
            return false;
        }

        @Override
        public int getPrepareEdge() {
            return this.prepareEdge;
        }

        @Override
        public int getNodeA() {
            return this.nodeA;
        }

        @Override
        public int getNodeB() {
            return this.nodeB;
        }

        @Override
        public double getWeightAB() {
            return this.weightAB;
        }

        @Override
        public double getWeightBA() {
            return this.weightBA;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            return GHUtility.createEdgeKey(this.prepareEdge, false);
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            return GHUtility.createEdgeKey(this.prepareEdge, true);
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            return this.getOrigEdgeKeyFirstAB();
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            return this.getOrigEdgeKeyFirstBA();
        }

        @Override
        public int getSkipped1() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSkipped2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOrigEdgeCount() {
            return 1;
        }

        @Override
        public void setSkipped1(int skipped1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSkipped2(int skipped2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrepareEdge getNextOut(int base) {
            if (base == this.nodeA) {
                return this.nextOutA;
            }
            if (base == this.nodeB) {
                return this.nextOutB;
            }
            throw new IllegalStateException("Cannot get next out edge as the given base " + base + " is not adjacent to the current edge");
        }

        @Override
        public void setNextOut(int base, PrepareEdge prepareEdge) {
            if (base == this.nodeA) {
                this.nextOutA = prepareEdge;
            } else if (base == this.nodeB) {
                this.nextOutB = prepareEdge;
            } else {
                throw new IllegalStateException("Cannot set next out edge as the given base " + base + " is not adjacent to the current edge");
            }
        }

        @Override
        public PrepareEdge getNextIn(int base) {
            if (base == this.nodeA) {
                return this.nextInA;
            }
            if (base == this.nodeB) {
                return this.nextInB;
            }
            throw new IllegalStateException("Cannot get next in edge as the given base " + base + " is not adjacent to the current edge");
        }

        @Override
        public void setNextIn(int base, PrepareEdge prepareEdge) {
            if (base == this.nodeA) {
                this.nextInA = prepareEdge;
            } else if (base == this.nodeB) {
                this.nextInB = prepareEdge;
            } else {
                throw new IllegalStateException("Cannot set next in edge as the given base " + base + " is not adjacent to the current edge");
            }
        }

        public String toString() {
            return this.nodeA + "-" + this.nodeB + " (" + this.prepareEdge + ") " + this.weightAB + " " + this.weightBA;
        }
    }

    static interface PrepareEdge {
        public boolean isShortcut();

        public int getPrepareEdge();

        public int getNodeA();

        public int getNodeB();

        public double getWeightAB();

        public double getWeightBA();

        public int getOrigEdgeKeyFirstAB();

        public int getOrigEdgeKeyFirstBA();

        public int getOrigEdgeKeyLastAB();

        public int getOrigEdgeKeyLastBA();

        public int getSkipped1();

        public int getSkipped2();

        public int getOrigEdgeCount();

        public void setSkipped1(int var1);

        public void setSkipped2(int var1);

        public void setWeight(double var1);

        public void setOrigEdgeCount(int var1);

        public PrepareEdge getNextOut(int var1);

        public void setNextOut(int var1, PrepareEdge var2);

        public PrepareEdge getNextIn(int var1);

        public void setNextIn(int var1, PrepareEdge var2);
    }

    private static class PrepareGraphEdgeExplorerImpl
    implements PrepareGraphEdgeExplorer,
    PrepareGraphEdgeIterator {
        private final PrepareEdge[] prepareEdges;
        private final boolean reverse;
        private int node = -1;
        private PrepareEdge currEdge;
        private PrepareEdge nextEdge;

        PrepareGraphEdgeExplorerImpl(PrepareEdge[] prepareEdges, boolean reverse) {
            this.prepareEdges = prepareEdges;
            this.reverse = reverse;
        }

        @Override
        public PrepareGraphEdgeIterator setBaseNode(int node) {
            this.node = node;
            this.currEdge = null;
            this.nextEdge = this.prepareEdges[node];
            return this;
        }

        @Override
        public boolean next() {
            this.currEdge = this.nextEdge;
            if (this.currEdge == null) {
                return false;
            }
            this.nextEdge = this.reverse ? this.currEdge.getNextIn(this.node) : this.currEdge.getNextOut(this.node);
            return true;
        }

        @Override
        public int getBaseNode() {
            return this.node;
        }

        @Override
        public int getAdjNode() {
            return this.nodeAisBase() ? this.currEdge.getNodeB() : this.currEdge.getNodeA();
        }

        @Override
        public int getPrepareEdge() {
            return this.currEdge.getPrepareEdge();
        }

        @Override
        public boolean isShortcut() {
            return this.currEdge.isShortcut();
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            return this.nodeAisBase() ? this.currEdge.getOrigEdgeKeyFirstAB() : this.currEdge.getOrigEdgeKeyFirstBA();
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.nodeAisBase() ? this.currEdge.getOrigEdgeKeyLastAB() : this.currEdge.getOrigEdgeKeyLastBA();
        }

        @Override
        public int getSkipped1() {
            return this.currEdge.getSkipped1();
        }

        @Override
        public int getSkipped2() {
            return this.currEdge.getSkipped2();
        }

        @Override
        public double getWeight() {
            if (this.nodeAisBase()) {
                return this.reverse ? this.currEdge.getWeightBA() : this.currEdge.getWeightAB();
            }
            return this.reverse ? this.currEdge.getWeightAB() : this.currEdge.getWeightBA();
        }

        @Override
        public int getOrigEdgeCount() {
            return this.currEdge.getOrigEdgeCount();
        }

        @Override
        public void setSkippedEdges(int skipped1, int skipped2) {
            this.currEdge.setSkipped1(skipped1);
            this.currEdge.setSkipped2(skipped2);
        }

        @Override
        public void setWeight(double weight) {
            assert (Double.isFinite(weight));
            this.currEdge.setWeight(weight);
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            this.currEdge.setOrigEdgeCount(origEdgeCount);
        }

        public String toString() {
            return this.currEdge == null ? "not_started" : this.currEdge.toString();
        }

        private boolean nodeAisBase() {
            return this.currEdge.getNodeA() == this.node;
        }
    }

    @FunctionalInterface
    public static interface TurnCostFunction {
        public double getTurnWeight(int var1, int var2, int var3);
    }
}

