/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntContainer;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.NodeBasedWitnessPathSearcher;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class NodeBasedNodeContractor
implements NodeContractor {
    private final CHPreparationGraph prepareGraph;
    private final Params params = new Params();
    private List<Shortcut> shortcuts = new ArrayList<Shortcut>();
    private CHStorageBuilder chBuilder;
    private PrepareGraphEdgeExplorer inEdgeExplorer;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphEdgeExplorer existingShortcutExplorer;
    private NodeBasedWitnessPathSearcher witnessPathSearcher;
    private int addedShortcutsCount;
    private long dijkstraCount;
    private final StopWatch dijkstraSW = new StopWatch();
    private double meanDegree;
    private int originalEdgesCount;
    private int shortcutsCount;

    NodeBasedNodeContractor(CHPreparationGraph prepareGraph, CHStorageBuilder chBuilder, PMap pMap) {
        this.prepareGraph = prepareGraph;
        this.extractParams(pMap);
        this.chBuilder = chBuilder;
    }

    private void extractParams(PMap pMap) {
        this.params.edgeDifferenceWeight = pMap.getFloat("prepare.ch.node.edge_difference_weight", this.params.edgeDifferenceWeight);
        this.params.originalEdgesCountWeight = pMap.getFloat("prepare.ch.node.original_edge_count_weight", this.params.originalEdgesCountWeight);
        this.params.maxPollFactorHeuristic = pMap.getDouble("prepare.ch.node.max_poll_factor_heuristic", this.params.maxPollFactorHeuristic);
        this.params.maxPollFactorContraction = pMap.getDouble("prepare.ch.node.max_poll_factor_contraction", this.params.maxPollFactorContraction);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.existingShortcutExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.witnessPathSearcher = new NodeBasedWitnessPathSearcher(this.prepareGraph);
        this.meanDegree = (double)this.prepareGraph.getOriginalEdges() * 1.0 / (double)this.prepareGraph.getNodes();
    }

    @Override
    public void close() {
        this.prepareGraph.close();
        this.shortcuts = null;
        this.chBuilder = null;
        this.inEdgeExplorer = null;
        this.outEdgeExplorer = null;
        this.existingShortcutExplorer = null;
        this.witnessPathSearcher = null;
    }

    @Override
    public float calculatePriority(int node) {
        this.shortcutsCount = 0;
        this.originalEdgesCount = 0;
        this.findAndHandleShortcuts(node, this::countShortcuts, (int)(this.meanDegree * this.params.maxPollFactorHeuristic));
        int edgeDifference = this.shortcutsCount - this.prepareGraph.getDegree(node);
        return this.params.edgeDifferenceWeight * (float)edgeDifference + this.params.originalEdgesCountWeight * (float)this.originalEdgesCount;
    }

    @Override
    public IntContainer contractNode(int node) {
        long degree = this.findAndHandleShortcuts(node, this::addOrUpdateShortcut, (int)(this.meanDegree * this.params.maxPollFactorContraction));
        this.insertShortcuts(node);
        this.meanDegree = (this.meanDegree * 2.0 + (double)degree) / 3.0;
        return this.prepareGraph.disconnect(node);
    }

    private void insertShortcuts(int node) {
        this.shortcuts.clear();
        this.insertOutShortcuts(node);
        this.insertInShortcuts(node);
        int origEdges = this.prepareGraph.getOriginalEdges();
        for (Shortcut sc : this.shortcuts) {
            int shortcut = this.chBuilder.addShortcutNodeBased(sc.from, sc.to, sc.flags, sc.weight, sc.skippedEdge1, sc.skippedEdge2);
            if (sc.flags == PrepareEncoder.getScFwdDir()) {
                this.prepareGraph.setShortcutForPrepareEdge(sc.prepareEdgeFwd, origEdges + shortcut);
                continue;
            }
            if (sc.flags == PrepareEncoder.getScBwdDir()) {
                this.prepareGraph.setShortcutForPrepareEdge(sc.prepareEdgeBwd, origEdges + shortcut);
                continue;
            }
            this.prepareGraph.setShortcutForPrepareEdge(sc.prepareEdgeFwd, origEdges + shortcut);
            this.prepareGraph.setShortcutForPrepareEdge(sc.prepareEdgeBwd, origEdges + shortcut);
        }
        this.addedShortcutsCount += this.shortcuts.size();
    }

    private void insertOutShortcuts(int node) {
        PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            this.shortcuts.add(new Shortcut(iter.getPrepareEdge(), -1, node, iter.getAdjNode(), iter.getSkipped1(), iter.getSkipped2(), PrepareEncoder.getScFwdDir(), iter.getWeight()));
        }
    }

    private void insertInShortcuts(int node) {
        PrepareGraphEdgeIterator iter = this.inEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            int skippedEdge1 = iter.getSkipped2();
            int skippedEdge2 = iter.getSkipped1();
            boolean bidir = false;
            for (Shortcut sc : this.shortcuts) {
                if (sc.to != iter.getAdjNode() || Double.doubleToLongBits(sc.weight) != Double.doubleToLongBits(iter.getWeight()) || this.prepareGraph.getShortcutForPrepareEdge(sc.skippedEdge1) != this.prepareGraph.getShortcutForPrepareEdge(skippedEdge1) || this.prepareGraph.getShortcutForPrepareEdge(sc.skippedEdge2) != this.prepareGraph.getShortcutForPrepareEdge(skippedEdge2) || sc.flags != PrepareEncoder.getScFwdDir()) continue;
                sc.flags = PrepareEncoder.getScDirMask();
                sc.prepareEdgeBwd = iter.getPrepareEdge();
                bidir = true;
                break;
            }
            if (bidir) continue;
            this.shortcuts.add(new Shortcut(-1, iter.getPrepareEdge(), node, iter.getAdjNode(), skippedEdge1, skippedEdge2, PrepareEncoder.getScBwdDir(), iter.getWeight()));
        }
    }

    @Override
    public void finishContraction() {
        this.chBuilder.replaceSkippedEdges(this.prepareGraph::getShortcutForPrepareEdge);
    }

    @Override
    public String getStatisticsString() {
        return String.format(Locale.ROOT, "meanDegree: %.2f, dijkstras: %10s, mem: %10s", this.meanDegree, Helper.nf((long)this.dijkstraCount), this.witnessPathSearcher.getMemoryUsageAsString());
    }

    private long findAndHandleShortcuts(int node, PrepareShortcutHandler handler, int maxVisitedNodes) {
        long degree = 0L;
        PrepareGraphEdgeIterator incomingEdges = this.inEdgeExplorer.setBaseNode(node);
        while (incomingEdges.next()) {
            int fromNode = incomingEdges.getAdjNode();
            if (fromNode == node) {
                throw new IllegalStateException("Unexpected loop-edge at node: " + node);
            }
            double incomingEdgeWeight = incomingEdges.getWeight();
            if (Double.isInfinite(incomingEdgeWeight)) continue;
            PrepareGraphEdgeIterator outgoingEdges = this.outEdgeExplorer.setBaseNode(node);
            this.witnessPathSearcher.init(fromNode, node);
            ++degree;
            while (outgoingEdges.next()) {
                double existingDirectWeight;
                int toNode = outgoingEdges.getAdjNode();
                if (fromNode == toNode || Double.isInfinite(existingDirectWeight = incomingEdgeWeight + outgoingEdges.getWeight())) continue;
                this.dijkstraSW.start();
                ++this.dijkstraCount;
                double maxWeight = this.witnessPathSearcher.findUpperBound(toNode, existingDirectWeight, maxVisitedNodes);
                this.dijkstraSW.stop();
                if (maxWeight <= existingDirectWeight) continue;
                handler.handleShortcut(fromNode, toNode, existingDirectWeight, outgoingEdges.getPrepareEdge(), outgoingEdges.getOrigEdgeCount(), incomingEdges.getPrepareEdge(), incomingEdges.getOrigEdgeCount());
            }
        }
        return degree;
    }

    private void countShortcuts(int fromNode, int toNode, double existingDirectWeight, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
        ++this.shortcutsCount;
        this.originalEdgesCount += inOrigEdgeCount + outOrigEdgeCount;
    }

    private void addOrUpdateShortcut(int fromNode, int toNode, double weight, int outgoingEdge, int outOrigEdgeCount, int incomingEdge, int inOrigEdgeCount) {
        boolean exists = false;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(fromNode);
        while (iter.next()) {
            if (iter.getAdjNode() != toNode || !iter.isShortcut()) continue;
            exists = true;
            if (!(weight < iter.getWeight())) continue;
            iter.setWeight(weight);
            iter.setSkippedEdges(incomingEdge, outgoingEdge);
            iter.setOrigEdgeCount(inOrigEdgeCount + outOrigEdgeCount);
        }
        if (!exists) {
            this.prepareGraph.addShortcut(fromNode, toNode, -1, -1, incomingEdge, outgoingEdge, weight, inOrigEdgeCount + outOrigEdgeCount);
        }
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    private static class Shortcut {
        int prepareEdgeFwd;
        int prepareEdgeBwd;
        int from;
        int to;
        int skippedEdge1;
        int skippedEdge2;
        double weight;
        int flags;

        public Shortcut(int prepareEdgeFwd, int prepareEdgeBwd, int from, int to, int skippedEdge1, int skippedEdge2, int flags, double weight) {
            this.prepareEdgeFwd = prepareEdgeFwd;
            this.prepareEdgeBwd = prepareEdgeBwd;
            this.from = from;
            this.to = to;
            this.skippedEdge1 = skippedEdge1;
            this.skippedEdge2 = skippedEdge2;
            this.flags = flags;
            this.weight = weight;
        }

        public String toString() {
            String str = this.flags == PrepareEncoder.getScDirMask() ? this.from + "<->" : this.from + "->";
            return str + this.to + ", weight:" + this.weight + " (" + this.skippedEdge1 + "," + this.skippedEdge2 + ")";
        }
    }

    public static class Params {
        private float edgeDifferenceWeight = 10.0f;
        private float originalEdgesCountWeight = 1.0f;
        private double maxPollFactorHeuristic = 5.0;
        private double maxPollFactorContraction = 200.0;
    }

    @FunctionalInterface
    private static interface PrepareShortcutHandler {
        public void handleShortcut(int var1, int var2, double var3, int var5, int var6, int var7, int var8);
    }
}

