/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.State;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Country {
    MISSING("missing", "---", "--", new State[0]),
    AFG("Afghanistan", "AFG", "AF", new State[0]),
    AGO("Angola", "AGO", "AO", new State[0]),
    AIA("Anguilla", "AIA", "AI", new State[0]),
    ALB("Albania", "ALB", "AL", new State[0]),
    AND("Andorra", "AND", "AD", new State[0]),
    ARE("United Arab Emirates", "ARE", "AE", new State[0]),
    ARG("Argentina", "ARG", "AR", new State[0]),
    ARM("Armenia", "ARM", "AM", new State[0]),
    ATG("Antigua and Barbuda", "ATG", "AG", new State[0]),
    AUS("Australia", "AUS", "AU", State.AU_ACT, State.AU_NSW, State.AU_NT, State.AU_QLD, State.AU_SA, State.AU_TAS, State.AU_VIC, State.AU_WA),
    AUT("Austria", "AUT", "AT", new State[0]),
    AZE("Azerbaijan", "AZE", "AZ", new State[0]),
    BDI("Burundi", "BDI", "BI", new State[0]),
    BEL("Belgium", "BEL", "BE", new State[0]),
    BEN("Benin", "BEN", "BJ", new State[0]),
    BFA("Burkina Faso", "BFA", "BF", new State[0]),
    BGD("Bangladesh", "BGD", "BD", new State[0]),
    BGR("Bulgaria", "BGR", "BG", new State[0]),
    BHR("Bahrain", "BHR", "BH", new State[0]),
    BHS("The Bahamas", "BHS", "BS", new State[0]),
    BIH("Bosnia and Herzegovina", "BIH", "BA", new State[0]),
    BLR("Belarus", "BLR", "BY", new State[0]),
    BLZ("Belize", "BLZ", "BZ", new State[0]),
    BMU("Bermuda", "BMU", "BM", new State[0]),
    BOL("Bolivia", "BOL", "BO", new State[0]),
    BRA("Brazil", "BRA", "BR", new State[0]),
    BRB("Barbados", "BRB", "BB", new State[0]),
    BRN("Brunei", "BRN", "BN", new State[0]),
    BTN("Bhutan", "BTN", "BT", new State[0]),
    BWA("Botswana", "BWA", "BW", new State[0]),
    CAF("Central African Republic", "CAF", "CF", new State[0]),
    CAN("Canada", "CAN", "CA", State.CA_AB, State.CA_BC, State.CA_MB, State.CA_NB, State.CA_NL, State.CA_NS, State.CA_NT, State.CA_NU, State.CA_ON, State.CA_PE, State.CA_QC, State.CA_SK, State.CA_YT),
    CHE("Switzerland", "CHE", "CH", new State[0]),
    CHL("Chile", "CHL", "CL", new State[0]),
    CHN("China", "CHN", "CN", new State[0]),
    CIV("C\u00f4te d'Ivoire", "CIV", "CI", new State[0]),
    CMR("Cameroon", "CMR", "CM", new State[0]),
    COD("Democratic Republic of the Congo", "COD", "CD", new State[0]),
    COG("Congo-Brazzaville", "COG", "CG", new State[0]),
    COK("Cook Islands", "COK", "CK", new State[0]),
    COL("Colombia", "COL", "CO", new State[0]),
    COM("Comoros", "COM", "KM", new State[0]),
    CPV("Cape Verde", "CPV", "CV", new State[0]),
    CRI("Costa Rica", "CRI", "CR", new State[0]),
    CUB("Cuba", "CUB", "CU", new State[0]),
    CYM("Cayman Islands", "CYM", "KY", new State[0]),
    CYP("Cyprus", "CYP", "CY", new State[0]),
    CZE("Czechia", "CZE", "CZ", new State[0]),
    DEU("Germany", "DEU", "DE", new State[0]),
    DJI("Djibouti", "DJI", "DJ", new State[0]),
    DMA("Dominica", "DMA", "DM", new State[0]),
    DNK("Denmark", "DNK", "DK", new State[0]),
    DOM("Dominican Republic", "DOM", "DO", new State[0]),
    DZA("Algeria", "DZA", "DZ", new State[0]),
    ECU("Ecuador", "ECU", "EC", new State[0]),
    EGY("Egypt", "EGY", "EG", new State[0]),
    ERI("Eritrea", "ERI", "ER", new State[0]),
    ESP("Spain", "ESP", "ES", new State[0]),
    EST("Estonia", "EST", "EE", new State[0]),
    ETH("Ethiopia", "ETH", "ET", new State[0]),
    FIN("Finland", "FIN", "FI", new State[0]),
    FJI("Fiji", "FJI", "FJ", new State[0]),
    FLK("Falkland Islands", "FLK", "FK", new State[0]),
    FRA("France", "FRA", "FR", new State[0]),
    FRO("Faroe Islands", "FRO", "FO", new State[0]),
    FSM("Federated States of Micronesia", "FSM", "FM", State.FM_KSA, State.FM_PNI, State.FM_TRK, State.FM_YAP),
    GAB("Gabon", "GAB", "GA", new State[0]),
    GBR("United Kingdom", "GBR", "GB", new State[0]),
    GEO("Georgia", "GEO", "GE", new State[0]),
    GGY("Guernsey", "GGY", "GG", new State[0]),
    GHA("Ghana", "GHA", "GH", new State[0]),
    GIB("Gibraltar", "GIB", "GI", new State[0]),
    GIN("Guinea", "GIN", "GN", new State[0]),
    GMB("The Gambia", "GMB", "GM", new State[0]),
    GNB("Guinea-Bissau", "GNB", "GW", new State[0]),
    GNQ("Equatorial Guinea", "GNQ", "GQ", new State[0]),
    GRC("Greece", "GRC", "GR", new State[0]),
    GRD("Grenada", "GRD", "GD", new State[0]),
    GRL("Greenland", "GRL", "GL", new State[0]),
    GTM("Guatemala", "GTM", "GT", new State[0]),
    GUY("Guyana", "GUY", "GY", new State[0]),
    HND("Honduras", "HND", "HN", new State[0]),
    HRV("Croatia", "HRV", "HR", new State[0]),
    HTI("Haiti", "HTI", "HT", new State[0]),
    HUN("Hungary", "HUN", "HU", new State[0]),
    IDN("Indonesia", "IDN", "ID", new State[0]),
    IMN("Isle of Man", "IMN", "IM", new State[0]),
    IND("India", "IND", "IN", new State[0]),
    IOT("British Indian Ocean Territory", "IOT", "IO", new State[0]),
    IRL("Ireland", "IRL", "IE", new State[0]),
    IRN("Iran", "IRN", "IR", new State[0]),
    IRQ("Iraq", "IRQ", "IQ", new State[0]),
    ISL("Iceland", "ISL", "IS", new State[0]),
    ISR("Israel", "ISR", "IL", new State[0]),
    ITA("Italy", "ITA", "IT", new State[0]),
    JAM("Jamaica", "JAM", "JM", new State[0]),
    JEY("Jersey", "JEY", "JE", new State[0]),
    JOR("Jordan", "JOR", "JO", new State[0]),
    JPN("Japan", "JPN", "JP", new State[0]),
    KAZ("Kazakhstan", "KAZ", "KZ", new State[0]),
    KEN("Kenya", "KEN", "KE", new State[0]),
    KGZ("Kyrgyzstan", "KGZ", "KG", new State[0]),
    KHM("Cambodia", "KHM", "KH", new State[0]),
    KIR("Kiribati", "KIR", "KI", new State[0]),
    KNA("Saint Kitts and Nevis", "KNA", "KN", new State[0]),
    KOR("South Korea", "KOR", "KR", new State[0]),
    KWT("Kuwait", "KWT", "KW", new State[0]),
    LAO("Laos", "LAO", "LA", new State[0]),
    LBN("Lebanon", "LBN", "LB", new State[0]),
    LBR("Liberia", "LBR", "LR", new State[0]),
    LBY("Libya", "LBY", "LY", new State[0]),
    LCA("Saint Lucia", "LCA", "LC", new State[0]),
    LIE("Liechtenstein", "LIE", "LI", new State[0]),
    LKA("Sri Lanka", "LKA", "LK", new State[0]),
    LSO("Lesotho", "LSO", "LS", new State[0]),
    LTU("Lithuania", "LTU", "LT", new State[0]),
    LUX("Luxembourg", "LUX", "LU", new State[0]),
    LVA("Latvia", "LVA", "LV", new State[0]),
    MAR("Morocco", "MAR", "MA", new State[0]),
    MCO("Monaco", "MCO", "MC", new State[0]),
    MDA("Moldova", "MDA", "MD", new State[0]),
    MDG("Madagascar", "MDG", "MG", new State[0]),
    MDV("Maldives", "MDV", "MV", new State[0]),
    MEX("Mexico", "MEX", "MX", new State[0]),
    MHL("Marshall Islands", "MHL", "MH", new State[0]),
    MKD("North Macedonia", "MKD", "MK", new State[0]),
    MLI("Mali", "MLI", "ML", new State[0]),
    MLT("Malta", "MLT", "MT", new State[0]),
    MMR("Myanmar", "MMR", "MM", new State[0]),
    MNE("Montenegro", "MNE", "ME", new State[0]),
    MNG("Mongolia", "MNG", "MN", new State[0]),
    MOZ("Mozambique", "MOZ", "MZ", new State[0]),
    MRT("Mauritania", "MRT", "MR", new State[0]),
    MSR("Montserrat", "MSR", "MS", new State[0]),
    MUS("Mauritius", "MUS", "MU", new State[0]),
    MWI("Malawi", "MWI", "MW", new State[0]),
    MYS("Malaysia", "MYS", "MY", new State[0]),
    NAM("Namibia", "NAM", "NA", new State[0]),
    NER("Niger", "NER", "NE", new State[0]),
    NGA("Nigeria", "NGA", "NG", new State[0]),
    NIC("Nicaragua", "NIC", "NI", new State[0]),
    NIU("Niue", "NIU", "NU", new State[0]),
    NLD("Netherlands", "NLD", "NL", new State[0]),
    NOR("Norway", "NOR", "NO", new State[0]),
    NPL("Nepal", "NPL", "NP", new State[0]),
    NRU("Nauru", "NRU", "NR", new State[0]),
    NZL("New Zealand", "NZL", "NZ", new State[0]),
    OMN("Oman", "OMN", "OM", new State[0]),
    PAK("Pakistan", "PAK", "PK", new State[0]),
    PAN("Panama", "PAN", "PA", new State[0]),
    PCN("Pitcairn Islands", "PCN", "PN", new State[0]),
    PER("Peru", "PER", "PE", new State[0]),
    PHL("Philippines", "PHL", "PH", new State[0]),
    PLW("Palau", "PLW", "PW", new State[0]),
    PNG("Papua New Guinea", "PNG", "PG", new State[0]),
    POL("Poland", "POL", "PL", new State[0]),
    PRK("North Korea", "PRK", "KP", new State[0]),
    PRT("Portugal", "PRT", "PT", new State[0]),
    PRY("Paraguay", "PRY", "PY", new State[0]),
    PSE("Palestinian Territories", "PSE", "PS", new State[0]),
    QAT("Qatar", "QAT", "QA", new State[0]),
    ROU("Romania", "ROU", "RO", new State[0]),
    RUS("Russia", "RUS", "RU", new State[0]),
    RWA("Rwanda", "RWA", "RW", new State[0]),
    SAU("Saudi Arabia", "SAU", "SA", new State[0]),
    SDN("Sudan", "SDN", "SD", new State[0]),
    SEN("Senegal", "SEN", "SN", new State[0]),
    SGP("Singapore", "SGP", "SG", new State[0]),
    SGS("South Georgia and the South Sandwich Islands", "SGS", "GS", new State[0]),
    SHN("Saint Helena, Ascension and Tristan da Cunha", "SHN", "SH", new State[0]),
    SLB("Solomon Islands", "SLB", "SB", new State[0]),
    SLE("Sierra Leone", "SLE", "SL", new State[0]),
    SLV("El Salvador", "SLV", "SV", new State[0]),
    SMR("San Marino", "SMR", "SM", new State[0]),
    SOM("Somalia", "SOM", "SO", new State[0]),
    SRB("Serbia", "SRB", "RS", new State[0]),
    SSD("South Sudan", "SSD", "SS", new State[0]),
    STP("S\u00e3o Tom\u00e9 and Pr\u00edncipe", "STP", "ST", new State[0]),
    SUR("Suriname", "SUR", "SR", new State[0]),
    SVK("Slovakia", "SVK", "SK", new State[0]),
    SVN("Slovenia", "SVN", "SI", new State[0]),
    SWE("Sweden", "SWE", "SE", new State[0]),
    SWZ("Eswatini", "SWZ", "SZ", new State[0]),
    SYC("Seychelles", "SYC", "SC", new State[0]),
    SYR("Syria", "SYR", "SY", new State[0]),
    TCA("Turks and Caicos Islands", "TCA", "TC", new State[0]),
    TCD("Chad", "TCD", "TD", new State[0]),
    TGO("Togo", "TGO", "TG", new State[0]),
    THA("Thailand", "THA", "TH", new State[0]),
    TJK("Tajikistan", "TJK", "TJ", new State[0]),
    TKL("Tokelau", "TKL", "TK", new State[0]),
    TKM("Turkmenistan", "TKM", "TM", new State[0]),
    TLS("East Timor", "TLS", "TL", new State[0]),
    TON("Tonga", "TON", "TO", new State[0]),
    TTO("Trinidad and Tobago", "TTO", "TT", new State[0]),
    TUN("Tunisia", "TUN", "TN", new State[0]),
    TUR("Turkey", "TUR", "TR", new State[0]),
    TUV("Tuvalu", "TUV", "TV", new State[0]),
    TWN("Taiwan", "TWN", "TW", new State[0]),
    TZA("Tanzania", "TZA", "TZ", new State[0]),
    UGA("Uganda", "UGA", "UG", new State[0]),
    UKR("Ukraine", "UKR", "UA", new State[0]),
    URY("Uruguay", "URY", "UY", new State[0]),
    USA("United States", "USA", "US", State.US_AL, State.US_AK, State.US_AZ, State.US_AR, State.US_CA, State.US_CO, State.US_CT, State.US_DE, State.US_DC, State.US_FL, State.US_GA, State.US_HI, State.US_ID, State.US_IL, State.US_IN, State.US_IA, State.US_KS, State.US_KY, State.US_LA, State.US_ME, State.US_MD, State.US_MA, State.US_MI, State.US_MN, State.US_MS, State.US_MO, State.US_MT, State.US_NE, State.US_NV, State.US_NH, State.US_NJ, State.US_NM, State.US_NY, State.US_NC, State.US_ND, State.US_OH, State.US_OK, State.US_OR, State.US_PA, State.US_RI, State.US_SC, State.US_SD, State.US_TN, State.US_TX, State.US_UT, State.US_VT, State.US_VA, State.US_WA, State.US_WV, State.US_WI, State.US_WY),
    UZB("Uzbekistan", "UZB", "UZ", new State[0]),
    VAT("Vatican City", "VAT", "VA", new State[0]),
    VCT("Saint Vincent and the Grenadines", "VCT", "VC", new State[0]),
    VEN("Venezuela", "VEN", "VE", new State[0]),
    VGB("British Virgin Islands", "VGB", "VG", new State[0]),
    VNM("Vietnam", "VNM", "VN", new State[0]),
    VUT("Vanuatu", "VUT", "VU", new State[0]),
    WSM("Samoa", "WSM", "WS", new State[0]),
    XKX("Kosovo", "XKX", "XK", new State[0]),
    YEM("Yemen", "YEM", "YE", new State[0]),
    ZAF("South Africa", "ZAF", "ZA", new State[0]),
    ZMB("Zambia", "ZMB", "ZM", new State[0]),
    ZWE("Zimbabwe", "ZWE", "ZW", new State[0]);

    public static final String KEY = "country";
    private static final Map<String, Country> ALPHA2_MAP;
    private final String countryName;
    private final String alpha2;
    private final String alpha3;
    private final List<State> states;

    private Country(String countryName, String alpha3, String alpha2, State ... states) {
        this.countryName = countryName;
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
        this.states = Arrays.asList(states);
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getAlpha2() {
        return this.alpha2;
    }

    public String getAlpha3() {
        return this.alpha3;
    }

    public List<State> getStates() {
        return this.states;
    }

    public static EnumEncodedValue<Country> create() {
        return new EnumEncodedValue<Country>(KEY, Country.class);
    }

    public static Country find(String iso) {
        return ALPHA2_MAP.get(iso);
    }

    public String toString() {
        return this.alpha3;
    }

    static {
        ALPHA2_MAP = new HashMap<String, Country>();
        for (Country country : Country.values()) {
            if (country == MISSING) continue;
            ALPHA2_MAP.put(country.alpha2, country);
        }
    }
}

