/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PointList;
import java.util.ArrayList;
import java.util.List;

class QueryOverlay {
    private final PointList virtualNodes;
    private final IntArrayList closestEdges;
    private final List<VirtualEdgeIteratorState> virtualEdges;
    private final IntObjectMap<EdgeChanges> edgeChangesAtRealNodes;

    QueryOverlay(int numVirtualNodes, boolean is3D) {
        this.virtualNodes = new PointList(numVirtualNodes, is3D);
        this.virtualEdges = new ArrayList<VirtualEdgeIteratorState>(numVirtualNodes * 2);
        this.closestEdges = new IntArrayList(numVirtualNodes);
        this.edgeChangesAtRealNodes = new GHIntObjectHashMap(numVirtualNodes * 3);
    }

    int getNumVirtualEdges() {
        return this.virtualEdges.size();
    }

    void addVirtualEdge(VirtualEdgeIteratorState virtualEdge) {
        this.virtualEdges.add(virtualEdge);
    }

    VirtualEdgeIteratorState getVirtualEdge(int edgeId) {
        return this.virtualEdges.get(edgeId);
    }

    List<VirtualEdgeIteratorState> getVirtualEdges() {
        return this.virtualEdges;
    }

    IntObjectMap<EdgeChanges> getEdgeChangesAtRealNodes() {
        return this.edgeChangesAtRealNodes;
    }

    PointList getVirtualNodes() {
        return this.virtualNodes;
    }

    IntArrayList getClosestEdges() {
        return this.closestEdges;
    }

    static class EdgeChanges {
        private final List<EdgeIteratorState> additionalEdges;
        private final IntArrayList removedEdges;

        EdgeChanges(int expectedNumAdditionalEdges, int expectedNumRemovedEdges) {
            this.additionalEdges = new ArrayList<EdgeIteratorState>(expectedNumAdditionalEdges);
            this.removedEdges = new IntArrayList(expectedNumRemovedEdges);
        }

        List<EdgeIteratorState> getAdditionalEdges() {
            return this.additionalEdges;
        }

        IntArrayList getRemovedEdges() {
            return this.removedEdges;
        }
    }
}

