/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import de.westnordost.osm_legal_default_speeds.LegalDefaultSpeeds;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultMaxSpeedParser
implements TagParser {
    private final LegalDefaultSpeeds speeds;
    private DecimalEncodedValue ruralMaxSpeedEnc;
    private DecimalEncodedValue urbanMaxSpeedEnc;
    private EdgeIntAccess externalAccess;
    private final int SIZE = 3000;
    private final Map<Map<String, String>, Result> cache = new LinkedHashMap<Map<String, String>, Result>(3001, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 3000;
        }
    };

    public DefaultMaxSpeedParser(LegalDefaultSpeeds speeds) {
        this.speeds = speeds;
    }

    public void init(DecimalEncodedValue ruralMaxSpeedEnc, DecimalEncodedValue urbanMaxSpeedEnc, EdgeIntAccess externalAccess) {
        this.ruralMaxSpeedEnc = ruralMaxSpeedEnc;
        this.urbanMaxSpeedEnc = urbanMaxSpeedEnc;
        this.externalAccess = externalAccess;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess _ignoreAccess, ReaderWay way, IntsRef relationFlags) {
        if (this.externalAccess == null) {
            throw new IllegalArgumentException("Call init before using " + this.getClass().getName());
        }
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        Integer ruralSpeedInt = null;
        Integer urbanSpeedInt = null;
        if (Double.isNaN(maxSpeed)) {
            Country country = way.getTag("country", Country.MISSING);
            State state = way.getTag("country_state", State.MISSING);
            if (country != Country.MISSING) {
                String code = state == State.MISSING ? country.getAlpha2() : state.getStateCode();
                Map<String, String> tags = this.filter(way.getTags());
                if (country == Country.GBR) {
                    tags.put("lit", "yes");
                }
                Result result = this.cache.computeIfAbsent(tags, key -> {
                    Result internRes = new Result();
                    LegalDefaultSpeeds.Result tmpResult = this.speeds.getSpeedLimits(code, tags, Collections.emptyList(), (name, eval) -> (Boolean)eval.invoke() != false || "rural".equals(name));
                    if (tmpResult != null) {
                        internRes.rural = DefaultMaxSpeedParser.parseInt((String)tmpResult.getTags().get("maxspeed"));
                        if (internRes.rural == null && "130".equals(tmpResult.getTags().get("maxspeed:advisory"))) {
                            internRes.rural = 150;
                        }
                    }
                    if ((tmpResult = this.speeds.getSpeedLimits(code, tags, Collections.emptyList(), (name, eval) -> (Boolean)eval.invoke() != false || "urban".equals(name))) != null) {
                        internRes.urban = DefaultMaxSpeedParser.parseInt((String)tmpResult.getTags().get("maxspeed"));
                        if (internRes.urban == null && "130".equals(tmpResult.getTags().get("maxspeed:advisory"))) {
                            internRes.urban = 150;
                        }
                    }
                    return internRes;
                });
                ruralSpeedInt = result.rural;
                urbanSpeedInt = result.urban;
            }
        }
        this.urbanMaxSpeedEnc.setDecimal(false, edgeId, this.externalAccess, urbanSpeedInt == null ? Double.POSITIVE_INFINITY : (double)urbanSpeedInt.intValue());
        this.ruralMaxSpeedEnc.setDecimal(false, edgeId, this.externalAccess, ruralSpeedInt == null ? Double.POSITIVE_INFINITY : (double)ruralSpeedInt.intValue());
    }

    private Map<String, String> filter(Map<String, Object> tags) {
        HashMap<String, String> map = new HashMap<String, String>(tags.size());
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            String key = entry.getKey();
            if (!this.speeds.isRelevantTagKey(key) && !key.equals("country") && (!key.startsWith("maxspeed:") || key.endsWith(":conditional"))) continue;
            map.put(key, entry.getValue().toString());
        }
        return map;
    }

    private static Integer parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static class Result {
        Integer urban;
        Integer rural;

        private Result() {
        }
    }
}

