/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OSMMaxWeightParser
implements TagParser {
    private static final List<String> MAX_WEIGHT_TAGS = Arrays.asList("maxweight", "maxgcweight", "maxweightrating:hgv");
    private static final List<String> HGV_RESTRICTIONS = OSMRoadAccessParser.toOSMRestrictions(TransportationMode.HGV).stream().map(e -> e + ":conditional").collect(Collectors.toList());
    private final DecimalEncodedValue weightEncoder;

    public OSMMaxWeightParser(DecimalEncodedValue weightEncoder) {
        this.weightEncoder = weightEncoder;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        OSMValueExtractor.extractTons(edgeId, edgeIntAccess, way, this.weightEncoder, MAX_WEIGHT_TAGS);
        for (String restriction : HGV_RESTRICTIONS) {
            double dec;
            String value = way.getTag(restriction, "");
            if (!value.startsWith("no") || value.indexOf("@") >= 6 || Double.isNaN(dec = OSMValueExtractor.conditionalWeightToTons(value))) continue;
            this.weightEncoder.setDecimal(false, edgeId, edgeIntAccess, dec);
        }
    }
}

