/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;

public class WheelchairAverageSpeedParser
extends FootAverageSpeedParser {
    public WheelchairAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(properties.getString("name", VehicleSpeed.key("wheelchair"))), lookup.getDecimalEncodedValue("ferry_speed"));
    }

    protected WheelchairAverageSpeedParser(DecimalEncodedValue speedEnc, DecimalEncodedValue ferrySpeedEnc) {
        super(speedEnc, ferrySpeedEnc);
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                double ferrySpeed = FerrySpeedCalculator.minmax(this.ferrySpeedEnc.getDecimal(false, edgeId, edgeIntAccess), this.avgSpeedEnc);
                this.setSpeed(false, edgeId, edgeIntAccess, ferrySpeed);
                this.setSpeed(true, edgeId, edgeIntAccess, ferrySpeed);
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        this.setSpeed(false, edgeId, edgeIntAccess, 5.0);
        this.setSpeed(true, edgeId, edgeIntAccess, 5.0);
        this.applyWayTags(way, edgeId, edgeIntAccess);
    }

    public void applyWayTags(ReaderWay way, int edgeId, EdgeIntAccess edgeIntAccess) {
        PointList pl = way.getTag("point_list", null);
        if (pl == null) {
            throw new IllegalArgumentException("The artificial point_list tag is missing");
        }
        if (!way.hasTag("edge_distance", new String[0])) {
            throw new IllegalArgumentException("The artificial edge_distance tag is missing");
        }
        double fullDist2D = way.getTag("edge_distance", 0.0);
        if (Double.isInfinite(fullDist2D)) {
            throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
        }
        if (fullDist2D < 20.0 || !pl.is3D()) {
            return;
        }
        double prevEle = pl.getEle(0);
        double eleDelta = pl.getEle(pl.size() - 1) - prevEle;
        double elePercent = eleDelta / fullDist2D * 100.0;
        int smallInclinePercent = 3;
        double fwdSpeed = 0.0;
        double bwdSpeed = 0.0;
        int maxInclinePercent = 6;
        if (elePercent > (double)smallInclinePercent && elePercent < 6.0) {
            fwdSpeed = 2.0;
            bwdSpeed = 5.0;
        } else if (elePercent < (double)(-smallInclinePercent) && elePercent > -6.0) {
            fwdSpeed = 5.0;
            bwdSpeed = 2.0;
        } else if (elePercent > 6.0 || elePercent < -6.0) {
            if (fullDist2D > 50.0) {
                this.avgSpeedEnc.setDecimal(false, edgeId, edgeIntAccess, 0.0);
                this.avgSpeedEnc.setDecimal(true, edgeId, edgeIntAccess, 0.0);
                return;
            }
            fwdSpeed = 2.0;
            bwdSpeed = 2.0;
        }
        if (fwdSpeed > 0.0) {
            this.setSpeed(false, edgeId, edgeIntAccess, fwdSpeed);
        }
        if (bwdSpeed > 0.0) {
            this.setSpeed(true, edgeId, edgeIntAccess, bwdSpeed);
        }
    }
}

