/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers.helpers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.util.Helper;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMValueExtractor {
    private static final Pattern TON_PATTERN = Pattern.compile("tons?");
    private static final Pattern MGW_PATTERN = Pattern.compile("mgw");
    private static final Pattern WSPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern METER_PATTERN = Pattern.compile("meters?|mtrs?|mt|m\\.");
    private static final Pattern INCH_PATTERN = Pattern.compile("\"|''");
    private static final Pattern FEET_PATTERN = Pattern.compile("'|feet");
    private static final Pattern APPROX_PATTERN = Pattern.compile("~|approx");
    private static final Logger logger = LoggerFactory.getLogger(OSMValueExtractor.class);

    private OSMValueExtractor() {
    }

    public static void extractTons(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys) {
        String rawValue = way.getFirstPriorityTag(keys);
        double value = OSMValueExtractor.stringToTons(rawValue);
        if (Double.isNaN(value)) {
            value = Double.POSITIVE_INFINITY;
        }
        valueEncoder.setDecimal(false, edgeId, edgeIntAccess, value);
    }

    public static double conditionalWeightToTons(String value) {
        try {
            int index = value.indexOf("weight>");
            if (index < 0) {
                index = value.indexOf("weight >");
                if (index > 0) {
                    index += "weight >".length();
                }
            } else {
                index += "weight>".length();
            }
            if (index > 0) {
                int lastIndex = value.indexOf(41, index);
                if (lastIndex < 0) {
                    lastIndex = value.length() - 1;
                }
                if (lastIndex > index) {
                    return OSMValueExtractor.stringToTons(value.substring(index, lastIndex));
                }
            }
            return Double.NaN;
        }
        catch (Exception ex) {
            throw new RuntimeException("value " + value, ex);
        }
    }

    public static double stringToTons(String value) {
        value = TON_PATTERN.matcher(Helper.toLowerCase((String)value)).replaceAll("t");
        if (OSMValueExtractor.isInvalidValue(value = MGW_PATTERN.matcher(value).replaceAll("").trim())) {
            return Double.NaN;
        }
        double factor = 1.0;
        if (value.endsWith("st")) {
            value = value.substring(0, value.length() - 2);
            factor = 0.907194048807;
        } else if (value.endsWith("t")) {
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("lbs")) {
            value = value.substring(0, value.length() - 3);
            factor = 4.5359237E-4;
        } else if (value.endsWith("kg")) {
            value = value.substring(0, value.length() - 2);
            factor = 0.001;
        }
        try {
            return Double.parseDouble(value) * factor;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static void extractMeter(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, DecimalEncodedValue valueEncoder, List<String> keys) {
        String rawValue = way.getFirstPriorityTag(keys);
        double value = OSMValueExtractor.stringToMeter(rawValue);
        if (Double.isNaN(value)) {
            value = Double.POSITIVE_INFINITY;
        }
        valueEncoder.setDecimal(false, edgeId, edgeIntAccess, value);
    }

    public static double stringToMeter(String value) {
        value = WSPACE_PATTERN.matcher(Helper.toLowerCase((String)value)).replaceAll("");
        value = METER_PATTERN.matcher(value).replaceAll("m");
        value = INCH_PATTERN.matcher(value).replaceAll("in");
        if (OSMValueExtractor.isInvalidValue(value = FEET_PATTERN.matcher(value).replaceAll("ft"))) {
            return Double.NaN;
        }
        double factor = 1.0;
        double offset = 0.0;
        if (value.startsWith("~") || value.contains("approx")) {
            value = APPROX_PATTERN.matcher(value).replaceAll("").trim();
            factor = 0.8;
        }
        if (value.endsWith("in")) {
            int startIndex = value.indexOf("ft");
            startIndex = startIndex < 0 ? 0 : (startIndex += 2);
            String inchValue = value.substring(startIndex, value.length() - 2);
            value = value.substring(0, startIndex);
            try {
                offset = Double.parseDouble(inchValue) * 0.0254;
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (value.endsWith("ft")) {
            value = value.substring(0, value.length() - 2);
            factor *= 0.3048;
        } else if (value.endsWith("cm")) {
            value = value.substring(0, value.length() - 2);
            factor *= 0.01;
        } else if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.isEmpty()) {
            return offset;
        }
        try {
            return Double.parseDouble(value) * factor + offset;
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static boolean isInvalidValue(String value) {
        return (value = Helper.toLowerCase((String)value)).isEmpty() || value.startsWith("default") || value.equals("none") || value.equals("unknown") || value.contains("unrestricted") || value.startsWith("\u301c") || value.contains("narrow") || value.equals("unsigned") || value.equals("fixme") || value.equals("small") || value.contains(";") || value.contains(":") || value.contains("(") || value.contains(">") || value.contains("<") || value.contains("-") || value.contains(",");
    }

    public static double stringToKmh(String str) {
        double value;
        double factor;
        if (Helper.isEmpty((String)str)) {
            return Double.NaN;
        }
        if ("walk".equals(str)) {
            return 6.0;
        }
        if ("none".equals(str)) {
            return 150.0;
        }
        int mpInteger = str.indexOf("mp");
        int knotInteger = str.indexOf("knots");
        int kmInteger = str.indexOf("km");
        int kphInteger = str.indexOf("kph");
        if (mpInteger > 0) {
            str = str.substring(0, mpInteger).trim();
            factor = 1.609344;
        } else if (knotInteger > 0) {
            str = str.substring(0, knotInteger).trim();
            factor = 1.852;
        } else {
            if (kmInteger > 0) {
                str = str.substring(0, kmInteger).trim();
            } else if (kphInteger > 0) {
                str = str.substring(0, kphInteger).trim();
            }
            factor = 1.0;
        }
        try {
            value = (double)Integer.parseInt(str) * factor;
        }
        catch (Exception ex) {
            return Double.NaN;
        }
        if (value <= 0.0) {
            return Double.NaN;
        }
        return value;
    }
}

