/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.TokenType;
import org.codehaus.janino.Visitor;

public class ValueExpressionVisitor
implements Visitor.AtomVisitor<Boolean, Exception> {
    private static final Set<String> allowedMethodParents = new HashSet<String>(Arrays.asList("Math"));
    private static final Set<String> allowedMethods = new HashSet<String>(Arrays.asList("sqrt"));
    private final ParseResult result;
    private final NameValidator variableValidator;
    private String invalidMessage;

    public ValueExpressionVisitor(ParseResult result, NameValidator variableValidator) {
        this.result = result;
        this.variableValidator = variableValidator;
    }

    boolean isValidIdentifier(String identifier) {
        if (this.variableValidator.isValid(identifier)) {
            if (!Character.isUpperCase(identifier.charAt(0))) {
                this.result.guessedVariables.add(identifier);
            }
            return true;
        }
        return false;
    }

    public Boolean visitRvalue(Java.Rvalue rv) throws Exception {
        if (rv instanceof Java.AmbiguousName) {
            Java.AmbiguousName n = (Java.AmbiguousName)rv;
            if (n.identifiers.length == 1) {
                String arg = n.identifiers[0];
                if (this.isValidIdentifier(arg)) {
                    return true;
                }
                this.invalidMessage = "'" + arg + "' not available";
                return false;
            }
            this.invalidMessage = "identifier " + n + " invalid";
            return false;
        }
        if (rv instanceof Java.Literal) {
            return true;
        }
        if (rv instanceof Java.UnaryOperation) {
            Java.UnaryOperation uop = (Java.UnaryOperation)rv;
            this.result.operators.add(uop.operator);
            if (uop.operator.equals("-")) {
                return (Boolean)uop.operand.accept((Visitor.AtomVisitor)this);
            }
            return false;
        }
        if (rv instanceof Java.MethodInvocation) {
            Java.MethodInvocation mi = (Java.MethodInvocation)rv;
            if (allowedMethods.contains(mi.methodName) && mi.target != null) {
                Java.AmbiguousName n = (Java.AmbiguousName)mi.target.toRvalue();
                if (n.identifiers.length == 2 && allowedMethodParents.contains(n.identifiers[0])) {
                    if (mi.arguments.length == 0) {
                        this.result.guessedVariables.add(n.identifiers[0]);
                        return true;
                    }
                    if (mi.arguments.length == 1) {
                        return (Boolean)mi.arguments[0].accept((Visitor.AtomVisitor)this);
                    }
                }
            }
            this.invalidMessage = mi.methodName + " is an illegal method in a value expression";
            return false;
        }
        if (rv instanceof Java.ParenthesizedExpression) {
            return (Boolean)((Java.ParenthesizedExpression)rv).value.accept((Visitor.AtomVisitor)this);
        }
        if (rv instanceof Java.BinaryOperation) {
            Java.BinaryOperation binOp = (Java.BinaryOperation)rv;
            String op = binOp.operator;
            this.result.operators.add(op);
            if (op.equals("*") || op.equals("+") || binOp.operator.equals("-")) {
                return (Boolean)binOp.lhs.accept((Visitor.AtomVisitor)this) != false && (Boolean)binOp.rhs.accept((Visitor.AtomVisitor)this) != false;
            }
            this.invalidMessage = "invalid operation '" + op + "'";
            return false;
        }
        return false;
    }

    public Boolean visitPackage(Java.Package p) {
        return false;
    }

    public Boolean visitType(Java.Type t) {
        return false;
    }

    public Boolean visitConstructorInvocation(Java.ConstructorInvocation ci) {
        return false;
    }

    static ParseResult parse(String expression, NameValidator variableValidator) {
        ParseResult result = new ParseResult();
        try {
            Parser parser = new Parser(new Scanner("ignore", (Reader)new StringReader(expression)));
            Java.Atom atom = parser.parseConditionalExpression();
            if (parser.peek().type == TokenType.END_OF_INPUT) {
                result.guessedVariables = new LinkedHashSet<String>();
                result.operators = new LinkedHashSet<String>();
                ValueExpressionVisitor visitor = new ValueExpressionVisitor(result, variableValidator);
                result.ok = (Boolean)atom.accept((Visitor.AtomVisitor)visitor);
                result.invalidMessage = visitor.invalidMessage;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static MinMax findMinMax(Set<String> createdObjects, String valueExpression, EncodedValueLookup lookup) {
        ParseResult result = ValueExpressionVisitor.parse(valueExpression, lookup::hasEncodedValue);
        if (!result.ok) {
            throw new IllegalArgumentException(result.invalidMessage);
        }
        if (result.guessedVariables.size() > 1) {
            throw new IllegalArgumentException("Currently only a single EncodedValue is allowed on the right-hand side, but was " + result.guessedVariables.size() + ". Value expression: " + valueExpression);
        }
        try {
            double val = Double.parseDouble(valueExpression);
            return new MinMax(val, val);
        }
        catch (NumberFormatException val) {
            try {
                if (result.guessedVariables.isEmpty()) {
                    ExpressionEvaluator ee = new ExpressionEvaluator();
                    ee.cook(valueExpression);
                    double val2 = ((Number)ee.evaluate(new Object[0])).doubleValue();
                    return new MinMax(val2, val2);
                }
                createdObjects.addAll(result.guessedVariables);
                if (lookup.hasEncodedValue(valueExpression)) {
                    EncodedValue enc = lookup.getEncodedValue(valueExpression, EncodedValue.class);
                    double min = ValueExpressionVisitor.getMin(enc);
                    double max = ValueExpressionVisitor.getMax(enc);
                    return new MinMax(min, max);
                }
                ExpressionEvaluator ee = new ExpressionEvaluator();
                String var = result.guessedVariables.iterator().next();
                ee.setParameters(new String[]{var}, new Class[]{Double.TYPE});
                ee.cook(valueExpression);
                double max = ValueExpressionVisitor.getMax(lookup.getEncodedValue(var, EncodedValue.class));
                Number val1 = (Number)ee.evaluate(new Object[]{max});
                double min = ValueExpressionVisitor.getMin(lookup.getEncodedValue(var, EncodedValue.class));
                Number val2 = (Number)ee.evaluate(new Object[]{min});
                return new MinMax(Math.min(val1.doubleValue(), val2.doubleValue()), Math.max(val1.doubleValue(), val2.doubleValue()));
            }
            catch (InvocationTargetException | CompileException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    static double getMin(EncodedValue enc) {
        if (enc instanceof DecimalEncodedValue) {
            return ((DecimalEncodedValue)enc).getMinStorableDecimal();
        }
        if (enc instanceof IntEncodedValue) {
            return ((IntEncodedValue)enc).getMinStorableInt();
        }
        throw new IllegalArgumentException("Cannot use non-number data '" + enc.getName() + "' in value expression");
    }

    static double getMax(EncodedValue enc) {
        if (enc instanceof DecimalEncodedValue) {
            return ((DecimalEncodedValue)enc).getMaxStorableDecimal();
        }
        if (enc instanceof IntEncodedValue) {
            return ((IntEncodedValue)enc).getMaxStorableInt();
        }
        throw new IllegalArgumentException("Cannot use non-number data '" + enc.getName() + "' in value expression");
    }
}

