/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.isochrone.algorithm.Isochrone;
import com.graphhopper.isochrone.algorithm.RasterHullBuilder;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteResource.class);
    private final GraphHopper graphHopper;
    private final EncodingManager encodingManager;
    private final RasterHullBuilder rasterHullBuilder;

    @Inject
    public IsochroneResource(GraphHopper graphHopper, EncodingManager encodingManager, RasterHullBuilder rasterHullBuilder) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
        this.rasterHullBuilder = rasterHullBuilder;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @QueryParam(value="vehicle") @DefaultValue(value="car") String vehicle, @QueryParam(value="buckets") @DefaultValue(value="1") int buckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") GHPoint point, @QueryParam(value="result") @DefaultValue(value="polygon") String resultStr, @QueryParam(value="time_limit") @DefaultValue(value="600") long timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") double distanceInMeter) {
        ArrayList calcRes;
        if (buckets > 20 || buckets < 1) {
            throw new IllegalArgumentException("Number of buckets has to be in the range [1, 20]");
        }
        if (point == null) {
            throw new IllegalArgumentException("point parameter cannot be null");
        }
        StopWatch sw = new StopWatch().start();
        if (!this.encodingManager.supports(vehicle)) {
            throw new IllegalArgumentException("vehicle not supported:" + vehicle);
        }
        FlagEncoder encoder = this.encodingManager.getEncoder(vehicle);
        DefaultEdgeFilter edgeFilter = DefaultEdgeFilter.allEdges((FlagEncoder)encoder);
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        QueryResult qr = locationIndex.findClosest(point.lat, point.lon, (EdgeFilter)edgeFilter);
        if (!qr.isValid()) {
            throw new IllegalArgumentException("Point not found:" + point);
        }
        GraphHopperStorage graph = this.graphHopper.getGraphHopperStorage();
        QueryGraph queryGraph = new QueryGraph((Graph)graph);
        queryGraph.lookup(Collections.singletonList(qr));
        HintsMap hintsMap = new HintsMap();
        RouteResource.initHints(hintsMap, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        Weighting weighting = this.graphHopper.createWeighting(hintsMap, encoder, (Graph)graph);
        Isochrone isochrone = new Isochrone((Graph)queryGraph, weighting, reverseFlow);
        if (distanceInMeter > 0.0) {
            double maxMeter = 50000.0;
            if (distanceInMeter > maxMeter) {
                throw new IllegalArgumentException("Specify a limit of less than " + maxMeter / 1000.0 + "km");
            }
            if ((double)buckets > distanceInMeter / 500.0) {
                throw new IllegalArgumentException("Specify buckets less than the number of explored kilometers");
            }
            isochrone.setDistanceLimit(distanceInMeter);
        } else {
            long maxSeconds = 4800L;
            if (timeLimitInSeconds > maxSeconds) {
                throw new IllegalArgumentException("Specify a limit of less than " + maxSeconds + " seconds");
            }
            if ((long)buckets > timeLimitInSeconds / 60L) {
                throw new IllegalArgumentException("Specify buckets less than the number of explored minutes");
            }
            isochrone.setTimeLimit((double)timeLimitInSeconds);
        }
        ArrayList list = isochrone.searchGPS(qr.getClosestNode(), buckets);
        if (isochrone.getVisitedNodes() > this.graphHopper.getMaxVisitedNodes() / 5) {
            throw new IllegalArgumentException("Server side reset: too many junction nodes would have to explored (" + isochrone.getVisitedNodes() + "). Let us know if you need this increased.");
        }
        int counter = 0;
        for (List list2 : list) {
            if (list2.size() < 2) {
                throw new IllegalArgumentException("Too few points found for bucket " + counter + ". Please try a different 'point', a smaller 'buckets' count or a larger 'time_limit'. And let us know if you think this is a bug!");
            }
            ++counter;
        }
        if ("pointlist".equalsIgnoreCase(resultStr)) {
            calcRes = list;
        } else if ("polygon".equalsIgnoreCase(resultStr)) {
            list = this.rasterHullBuilder.calcList((List)list, list.size() - 1);
            ArrayList arrayList = new ArrayList();
            int index = 0;
            for (List list3 : list) {
                HashMap<String, Object> geoJsonMap = new HashMap<String, Object>();
                HashMap<String, Integer> propMap = new HashMap<String, Integer>();
                HashMap<String, Object> geometryMap = new HashMap<String, Object>();
                arrayList.add(geoJsonMap);
                geoJsonMap.put("type", "Feature");
                geoJsonMap.put("properties", propMap);
                geoJsonMap.put("geometry", geometryMap);
                propMap.put("bucket", index);
                geometryMap.put("type", "Polygon");
                geometryMap.put("coordinates", Collections.singletonList(list3));
                ++index;
            }
            calcRes = arrayList;
        } else {
            throw new IllegalArgumentException("type not supported:" + resultStr);
        }
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + isochrone.getVisitedNodes() + ", " + uriInfo.getQueryParameters());
        return Response.fromResponse((Response)this.jsonSuccessResponse(calcRes, sw.stop().getSeconds())).header("X-GH-Took", (Object)("" + sw.stop().getSeconds() * 1000.0f)).build();
    }

    private Response jsonSuccessResponse(Object result, float took) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.putPOJO("polygons", result);
        ObjectNode info = json.putObject("info");
        info.putArray("copyrights").add("GraphHopper").add("OpenStreetMap contributors");
        info.put("took", Math.round(took * 1000.0f));
        return Response.ok((Object)json).build();
    }
}

