/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jpl;

import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4jSystemLogger
implements System.Logger {
    private final ExtendedLogger logger;
    private static final String FQCN = Log4jSystemLogger.class.getName();

    public Log4jSystemLogger(ExtendedLogger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.logger.isEnabled(Log4jSystemLogger.getLevel(level));
    }

    @Override
    public void log(System.Logger.Level level, String msg) {
        this.log(level, (ResourceBundle)null, msg, (Object[])null);
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier) {
        Objects.requireNonNull(msgSupplier);
        if (this.isLoggable(Objects.requireNonNull(level))) {
            this.log(level, (ResourceBundle)null, msgSupplier.get(), (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, Object obj) {
        Objects.requireNonNull(obj);
        if (this.isLoggable(Objects.requireNonNull(level))) {
            this.log(level, (ResourceBundle)null, obj.toString(), (Object[])null);
        }
    }

    @Override
    public void log(System.Logger.Level level, String msg, Throwable thrown) {
        this.log(level, null, msg, thrown);
    }

    @Override
    public void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
        Objects.requireNonNull(msgSupplier);
        if (this.isLoggable(Objects.requireNonNull(level))) {
            this.log(level, null, msgSupplier.get(), thrown);
        }
    }

    @Override
    public void log(System.Logger.Level level, String format, Object ... params) {
        this.log(level, null, format, params);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.logger.logIfEnabled(FQCN, Log4jSystemLogger.getLevel(level), (Marker)null, Log4jSystemLogger.getResource(bundle, msg), thrown);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        this.logger.logIfEnabled(FQCN, Log4jSystemLogger.getLevel(level), (Marker)null, Log4jSystemLogger.getResource(bundle, format), params);
    }

    private static Level getLevel(System.Logger.Level level) {
        switch (level) {
            case OFF: {
                return Level.OFF;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARNING: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case ALL: {
                return Level.ALL;
            }
        }
        return Level.ERROR;
    }

    private static String getResource(ResourceBundle bundle, String msg) {
        if (bundle == null || msg == null) {
            return msg;
        }
        try {
            return bundle.getString(msg);
        }
        catch (MissingResourceException e) {
            return msg;
        }
        catch (ClassCastException ex) {
            return bundle.getObject(msg).toString();
        }
    }
}

