/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.fusesource.jansi.AnsiOutputStream;
import org.fusesource.jansi.AnsiProcessor;
import org.fusesource.jansi.FastBufferedOutputStream;
import org.fusesource.jansi.WindowsAnsiProcessor;
import org.fusesource.jansi.internal.CLibrary;
import org.fusesource.jansi.internal.Kernel32;

public class AnsiConsole {
    public static final PrintStream system_out = System.out;
    public static final PrintStream out;
    public static final PrintStream system_err;
    public static final PrintStream err;
    static final boolean IS_WINDOWS;
    static final boolean IS_CYGWIN;
    static final boolean IS_MSYSTEM;
    static final boolean IS_CONEMU;
    static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;
    public static final String JANSI_PASSTHROUGH = "jansi.passthrough";
    public static final String JANSI_STRIP = "jansi.strip";
    public static final String JANSI_FORCE = "jansi.force";
    private static JansiOutputType jansiOutputType;
    static final JansiOutputType JANSI_STDOUT_TYPE;
    static final JansiOutputType JANSI_STDERR_TYPE;
    private static int installed;

    private AnsiConsole() {
    }

    private static PrintStream ansiStream(boolean stdout) {
        int[] mode;
        long console2;
        FastBufferedOutputStream out = new FastBufferedOutputStream(new FileOutputStream(stdout ? FileDescriptor.out : FileDescriptor.err));
        String enc = System.getProperty(stdout ? "sun.stdout.encoding" : "sun.stderr.encoding");
        if (AnsiConsole.getBoolean(JANSI_PASSTHROUGH)) {
            jansiOutputType = JansiOutputType.PASSTHROUGH;
            return AnsiConsole.newPrintStream(out, enc);
        }
        if (AnsiConsole.getBoolean(JANSI_STRIP)) {
            jansiOutputType = JansiOutputType.STRIP_ANSI;
            return AnsiConsole.newPrintStream(new AnsiOutputStream((OutputStream)out, new AnsiProcessor(out), enc), enc);
        }
        if (IS_WINDOWS && Kernel32.GetConsoleMode(console2 = Kernel32.GetStdHandle(stdout ? Kernel32.STD_OUTPUT_HANDLE : Kernel32.STD_ERROR_HANDLE), mode = new int[1]) != 0 && Kernel32.SetConsoleMode(console2, mode[0] | 4) != 0) {
            jansiOutputType = JansiOutputType.VIRTUAL_TERMINAL;
            return AnsiConsole.newPrintStream(out, enc);
        }
        if (IS_WINDOWS && !IS_CONEMU && !IS_CYGWIN && !IS_MSYSTEM) {
            try {
                jansiOutputType = JansiOutputType.WINDOWS;
                return AnsiConsole.newPrintStream(new AnsiOutputStream((OutputStream)out, (AnsiProcessor)new WindowsAnsiProcessor(out, stdout), enc), enc);
            }
            catch (Throwable console2) {
                jansiOutputType = JansiOutputType.STRIP_ANSI;
                return AnsiConsole.newPrintStream(new AnsiOutputStream((OutputStream)out, new AnsiProcessor(out), enc), enc);
            }
        }
        try {
            boolean forceColored = AnsiConsole.getBoolean(JANSI_FORCE);
            if (!forceColored && CLibrary.isatty(stdout ? 1 : 2) == 0) {
                jansiOutputType = JansiOutputType.STRIP_ANSI;
                return AnsiConsole.newPrintStream(new AnsiOutputStream((OutputStream)out, new AnsiProcessor(out), enc), enc);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jansiOutputType = JansiOutputType.RESET_ANSI_AT_CLOSE;
        return AnsiConsole.newPrintStream(out, enc, AnsiOutputStream.RESET_CODE);
    }

    private static PrintStream newPrintStream(OutputStream out, String enc) {
        return AnsiConsole.newPrintStream(out, enc, null);
    }

    private static PrintStream newPrintStream(OutputStream out, String enc, byte[] reset) {
        if (enc != null) {
            try {
                return new ResetAtClosePrintStream(out, enc, reset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new ResetAtClosePrintStream(out, reset);
    }

    static boolean getBoolean(String name) {
        boolean result = false;
        try {
            String val = System.getProperty(name);
            result = val.isEmpty() || Boolean.parseBoolean(val);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return result;
    }

    public static PrintStream out() {
        return out;
    }

    public static PrintStream err() {
        return err;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }

    static {
        system_err = System.err;
        IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/");
        IS_MSYSTEM = IS_WINDOWS && System.getenv("MSYSTEM") != null && (System.getenv("MSYSTEM").startsWith("MINGW") || System.getenv("MSYSTEM").equals("MSYS"));
        IS_CONEMU = IS_WINDOWS && System.getenv("ConEmuPID") != null;
        out = AnsiConsole.ansiStream(true);
        JANSI_STDOUT_TYPE = jansiOutputType;
        err = AnsiConsole.ansiStream(false);
        JANSI_STDERR_TYPE = jansiOutputType;
    }

    static enum JansiOutputType {
        PASSTHROUGH("just pass through, ANSI escape codes are supposed to be supported by terminal"),
        RESET_ANSI_AT_CLOSE("like pass through but reset ANSI attributes when closing the stream"),
        STRIP_ANSI("strip ANSI escape codes, for example when output is not a terminal"),
        WINDOWS("detect ANSI escape codes and transform Jansi-supported ones into a Windows API to get desired effect (since ANSI escape codes are not natively supported by Windows terminals like cmd.exe or PowerShell)"),
        VIRTUAL_TERMINAL("recent Windows support ANSI processing using a windows API call to configure the console in the correct mode");

        private final String description;

        private JansiOutputType(String description) {
            this.description = description;
        }

        String getDescription() {
            return this.description;
        }
    }

    static class ResetAtClosePrintStream
    extends PrintStream {
        private final byte[] reset;

        public ResetAtClosePrintStream(OutputStream out, byte[] reset) {
            super(out, true);
            this.reset = reset;
        }

        public ResetAtClosePrintStream(OutputStream out, String encoding, byte[] reset) throws UnsupportedEncodingException {
            super(out, true, encoding);
            this.reset = reset;
        }

        @Override
        public void close() {
            if (this.reset != null) {
                this.write(this.reset, 0, this.reset.length);
            }
            super.close();
        }
    }
}

