/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.fusesource.jansi.AnsiProcessor;

public class AnsiOutputStream
extends FilterOutputStream {
    public static final byte[] RESET_CODE = "\u001b[0m".getBytes();
    private static final int LOOKING_FOR_FIRST_ESC_CHAR = 0;
    private static final int LOOKING_FOR_SECOND_ESC_CHAR = 1;
    private static final int LOOKING_FOR_NEXT_ARG = 2;
    private static final int LOOKING_FOR_STR_ARG_END = 3;
    private static final int LOOKING_FOR_INT_ARG_END = 4;
    private static final int LOOKING_FOR_OSC_COMMAND = 5;
    private static final int LOOKING_FOR_OSC_COMMAND_END = 6;
    private static final int LOOKING_FOR_OSC_PARAM = 7;
    private static final int LOOKING_FOR_ST = 8;
    private static final int LOOKING_FOR_CHARSET = 9;
    private static final int FIRST_ESC_CHAR = 27;
    private static final int SECOND_ESC_CHAR = 91;
    private static final int SECOND_OSC_CHAR = 93;
    private static final int BEL = 7;
    private static final int SECOND_ST_CHAR = 92;
    private static final int SECOND_CHARSET0_CHAR = 40;
    private static final int SECOND_CHARSET1_CHAR = 41;
    private final AnsiProcessor ap;
    private static final int MAX_ESCAPE_SEQUENCE_LENGTH = 100;
    private final byte[] buffer = new byte[100];
    private int pos = 0;
    private int startOfValue;
    private final ArrayList<Object> options = new ArrayList();
    private int state = 0;
    private final Charset cs;

    public AnsiOutputStream(OutputStream os, AnsiProcessor ap) {
        this(os, ap, Charset.defaultCharset());
    }

    public AnsiOutputStream(OutputStream os, AnsiProcessor ap, Charset cs) {
        super(os);
        this.ap = ap;
        this.cs = cs;
    }

    public AnsiOutputStream(OutputStream os, AnsiProcessor ap, String encoding) {
        super(os);
        this.ap = ap;
        this.cs = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
    }

    @Override
    public void write(int data) throws IOException {
        switch (this.state) {
            case 0: {
                if (data == 27) {
                    this.buffer[this.pos++] = (byte)data;
                    this.state = 1;
                    break;
                }
                this.out.write(data);
                break;
            }
            case 1: {
                this.buffer[this.pos++] = (byte)data;
                if (data == 91) {
                    this.state = 2;
                    break;
                }
                if (data == 93) {
                    this.state = 5;
                    break;
                }
                if (data == 40) {
                    this.options.add(0);
                    this.state = 9;
                    break;
                }
                if (data == 41) {
                    this.options.add(1);
                    this.state = 9;
                    break;
                }
                this.reset(false);
                break;
            }
            case 2: {
                this.buffer[this.pos++] = (byte)data;
                if (34 == data) {
                    this.startOfValue = this.pos - 1;
                    this.state = 3;
                    break;
                }
                if (48 <= data && data <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 4;
                    break;
                }
                if (59 == data) {
                    this.options.add(null);
                    break;
                }
                if (63 == data) {
                    this.options.add(Character.valueOf('?'));
                    break;
                }
                if (61 == data) {
                    this.options.add(Character.valueOf('='));
                    break;
                }
                this.reset(this.ap.processEscapeCommand(this.options, data));
                break;
            }
            default: {
                break;
            }
            case 4: {
                this.buffer[this.pos++] = (byte)data;
                if (48 <= data && data <= 57) break;
                String strValue = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                Integer value = Integer.valueOf(strValue);
                this.options.add(value);
                if (data == 59) {
                    this.state = 2;
                    break;
                }
                this.reset(this.ap.processEscapeCommand(this.options, data));
                break;
            }
            case 3: {
                this.buffer[this.pos++] = (byte)data;
                if (34 == data) break;
                String value = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, this.cs);
                this.options.add(value);
                if (data == 59) {
                    this.state = 2;
                    break;
                }
                this.reset(this.ap.processEscapeCommand(this.options, data));
                break;
            }
            case 5: {
                this.buffer[this.pos++] = (byte)data;
                if (48 <= data && data <= 57) {
                    this.startOfValue = this.pos - 1;
                    this.state = 6;
                    break;
                }
                this.reset(false);
                break;
            }
            case 6: {
                this.buffer[this.pos++] = (byte)data;
                if (59 == data) {
                    String strValue = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue);
                    Integer value = Integer.valueOf(strValue);
                    this.options.add(value);
                    this.startOfValue = this.pos;
                    this.state = 7;
                    break;
                }
                if (48 <= data && data <= 57) break;
                this.reset(false);
                break;
            }
            case 7: {
                this.buffer[this.pos++] = (byte)data;
                if (7 == data) {
                    String value = new String(this.buffer, this.startOfValue, this.pos - 1 - this.startOfValue, this.cs);
                    this.options.add(value);
                    this.reset(this.ap.processOperatingSystemCommand(this.options));
                    break;
                }
                if (27 != data) break;
                this.state = 8;
                break;
            }
            case 8: {
                this.buffer[this.pos++] = (byte)data;
                if (92 == data) {
                    String value = new String(this.buffer, this.startOfValue, this.pos - 2 - this.startOfValue, this.cs);
                    this.options.add(value);
                    this.reset(this.ap.processOperatingSystemCommand(this.options));
                    break;
                }
                this.state = 7;
                break;
            }
            case 9: {
                this.options.add(Character.valueOf((char)data));
                this.reset(this.ap.processCharsetSelect(this.options));
            }
        }
        if (this.pos >= this.buffer.length) {
            this.reset(false);
        }
    }

    private void reset(boolean skipBuffer) throws IOException {
        if (!skipBuffer) {
            this.out.write(this.buffer, 0, this.pos);
        }
        this.pos = 0;
        this.startOfValue = 0;
        this.options.clear();
        this.state = 0;
    }
}

