/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.kotlin;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.password.AbstractHardcodedPasswordEqualsDetector;
import edu.umd.cs.findbugs.BugReporter;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class KotlinHardcodedPasswordEqualsDetector
extends AbstractHardcodedPasswordEqualsDetector {
    private static final String HARD_CODE_PASSWORD_TYPE = "HARD_CODE_PASSWORD";
    private static final InvokeMatcherBuilder KOTLIN_INTRINSICS_ARE_EQUALS_METHOD = InstructionDSL.invokeInstruction().atClass("kotlin/jvm/internal/Intrinsics").atMethod("areEqual").withArgs("(Ljava/lang/Object;Ljava/lang/Object;)Z");

    public KotlinHardcodedPasswordEqualsDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        if (KOTLIN_INTRINSICS_ARE_EQUALS_METHOD.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0, 1}, HARD_CODE_PASSWORD_TYPE);
        }
        return InjectionPoint.NONE;
    }
}

