/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class SignatureParserWithGeneric {
    private final List<String> argumentsTypes;
    private final String returnType;

    public SignatureParserWithGeneric(String signature) {
        GenericSignatureParser delegate = new GenericSignatureParser(signature);
        ArrayList arguments = new ArrayList();
        delegate.parameterSignatureIterator().forEachRemaining(arguments::add);
        this.argumentsTypes = Collections.unmodifiableList(arguments);
        this.returnType = delegate.getReturnTypeSignature();
    }

    public List<JavaClass[]> getArgumentsClasses() {
        ArrayList<JavaClass[]> types = new ArrayList<JavaClass[]>();
        for (String argumentType : this.argumentsTypes) {
            if (argumentType.equals("")) continue;
            types.add(this.typeToJavaClass(argumentType));
        }
        return types;
    }

    public JavaClass[] getReturnClasses() {
        return this.typeToJavaClass(this.returnType);
    }

    private JavaClass[] typeToJavaClass(String type) {
        Matcher m = Pattern.compile("([^<]+)(<([^>]+)>)?").matcher(type);
        ArrayList<JavaClass> types = new ArrayList<JavaClass>();
        if (m.find()) {
            try {
                types.add(Repository.lookupClass((String)this.cleanClassName(m.group(1))));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (m.groupCount() == 3 && m.group(3) != null) {
                try {
                    types.add(Repository.lookupClass((String)this.cleanClassName(m.group(3))));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return types.toArray(new JavaClass[types.size()]);
    }

    private String cleanClassName(String classname) {
        return classname.replaceAll("^L", "").replaceAll(";$", "").replaceAll("/", ".");
    }
}

