/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class WeakMessageDigestDetector
extends OpcodeStackDetector {
    private static final String WEAK_MESSAGE_DIGEST_TYPE = "WEAK_MESSAGE_DIGEST";
    private final BugReporter bugReporter;

    public WeakMessageDigestDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen != 184) {
            return;
        }
        String className = this.getClassConstantOperand();
        String methodName = this.getNameConstantOperand();
        if (className.equals("java/security/MessageDigest") && methodName.equals("getInstance")) {
            OpcodeStack.Item item;
            String methodSig = this.getSigConstantOperand();
            if (methodSig.equals("(Ljava/lang/String;)Ljava/security/MessageDigest;")) {
                item = this.stack.getStackItem(0);
            } else if (methodSig.equals("(Ljava/lang/String;Ljava/lang/String;)Ljava/security/MessageDigest;")) {
                item = this.stack.getStackItem(1);
            } else if (methodSig.equals("(Ljava/lang/String;Ljava/security/Provider;)Ljava/security/MessageDigest;")) {
                item = this.stack.getStackItem(1);
            } else {
                return;
            }
            String algorithm = (String)item.getConstant();
            this.checkHashFunction(algorithm);
        } else if (className.equals("org/apache/commons/codec/digest/DigestUtils")) {
            if (methodName.equals("getMd2Digest") || methodName.equals("md2") || methodName.equals("md2Hex")) {
                this.checkHashFunction("md2");
            } else if (methodName.equals("getMd5Digest") || methodName.equals("md5") || methodName.equals("md5Hex")) {
                this.checkHashFunction("md5");
            } else if (methodName.equals("getSha1Digest") || methodName.equals("getShaDigest") || methodName.equals("sha1") || methodName.equals("sha") || methodName.equals("sha1Hex") || methodName.equals("shaHex")) {
                this.checkHashFunction("sha1");
            } else if (methodName.equals("getDigest")) {
                OpcodeStack.Item top = this.stack.getStackItem(0);
                String algorithm = (String)top.getConstant();
                this.checkHashFunction(algorithm);
            }
        } else if (className.equals("java/security/Signature") && methodName.equals("getInstance")) {
            OpcodeStack.Item item;
            String methodSig = this.getSigConstantOperand();
            if (methodSig.equals("(Ljava/lang/String;)Ljava/security/Signature;")) {
                item = this.stack.getStackItem(0);
            } else if (methodSig.equals("(Ljava/lang/String;Ljava/security/Provider;)Ljava/security/Signature;")) {
                item = this.stack.getStackItem(1);
            } else if (methodSig.equals("(Ljava/lang/String;Ljava/lang/String;)Ljava/security/Signature;")) {
                item = this.stack.getStackItem(1);
            } else {
                return;
            }
            String algorithm = (String)item.getConstant();
            if (algorithm != null) {
                int index = algorithm.indexOf("with");
                algorithm = algorithm.substring(0, index > 0 ? index : 0);
                this.checkHashFunction(algorithm);
            }
        }
    }

    private void checkHashFunction(String algorithm) {
        if (algorithm == null) {
            return;
        }
        if ("MD2".equals(algorithm = algorithm.toUpperCase()) || "MD4".equals(algorithm) || "MD5".equals(algorithm)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_MESSAGE_DIGEST_TYPE, 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(algorithm));
        } else if ("SHA1".equals(algorithm)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, WEAK_MESSAGE_DIGEST_TYPE, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(algorithm));
        }
    }
}

