/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import edu.umd.cs.findbugs.BugReporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class ConfiguredBasicInjectionDetector
extends BasicInjectionDetector {
    private static final String SINK_CONFIG_PATH = "injection-sinks/";

    public ConfiguredBasicInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    protected void loadConfiguredSinks(String filename, String bugType) {
        assert (filename != null && bugType != null && !bugType.isEmpty());
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(SINK_CONFIG_PATH.concat(filename));
            this.loadSinks(stream, bugType);
        }
        catch (IOException ex) {
            throw new RuntimeException("cannot load resources", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("cannot close stream", ex);
                }
            }
        }
    }

    protected void loadSinks(InputStream input, String bugType) throws IOException {
        String line;
        assert (input != null && bugType != null && !bugType.isEmpty());
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("-")) continue;
            this.loadSink(line, bugType);
        }
    }

    protected void loadSink(String line, String bugType) {
        assert (line != null && bugType != null && !bugType.isEmpty());
        String[] split = line.split("\\:");
        if (split.length != 2) {
            throw new IllegalArgumentException("There must be exactly one ':' in " + line);
        }
        String[] stringArguments = split[1].split(",");
        int length = stringArguments.length;
        if (length == 0) {
            throw new IllegalArgumentException("no injectable parameters specified in " + line);
        }
        int[] intArguments = new int[length];
        for (int i = 0; i < length; ++i) {
            try {
                intArguments[i] = Integer.parseInt(stringArguments[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("cannot parse " + stringArguments[i], ex);
            }
        }
        this.addSink(split[0], intArguments, bugType);
    }
}

