/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs;

import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;

public class PredictableRandomDetector
extends OpcodeStackDetector {
    private static final String PREDICTABLE_RANDOM_TYPE = "PREDICTABLE_RANDOM";
    private static final String PREDICTABLE_RANDOM_SCALA_TYPE = "PREDICTABLE_RANDOM_SCALA";
    private static final InvokeMatcherBuilder RANDOM_NEXT_METHODS = InstructionDSL.invokeInstruction().atClass("scala/util/Random$").atMethod("nextBoolean", "nextBytes", "nextDouble", "nextFloat", "nextGaussian", "nextInt", "nextLong", "nextString", "nextPrintableChar");
    private static final InvokeMatcherBuilder RANDOM_STRING_UTILS_METHODS = InstructionDSL.invokeInstruction().atClass("org/apache/commons/lang/RandomStringUtils").atMethod("random", "randomAscii", "randomAlphabetic", "randomAlphanumeric", "randomGraph", "randomNumeric", "randomPrint");
    private static final InvokeMatcherBuilder RANDOM_UTILS_METHODS = InstructionDSL.invokeInstruction().atClass("org/apache/commons/lang/math/RandomUtils").atMethod("nextBoolean", "nextDouble", "nextFloat", "nextInt", "nextLong");
    private BugReporter bugReporter;

    public PredictableRandomDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void reportBug(String module, String error) {
        this.bugReporter.reportBug(new BugInstance((Detector)this, error, 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(module));
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.getClassConstantOperand().equals("java/util/Random") && this.getNameConstantOperand().equals("<init>")) {
            this.reportBug("java.util.Random", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/lang/Math") && this.getNameConstantOperand().equals("random")) {
            this.reportBug("java.lang.Math.random()", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/concurrent/ThreadLocalRandom") && this.getNameConstantOperand().equals("current")) {
            this.reportBug("java.util.concurrent.ThreadLocalRandom", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 183 && this.getClassConstantOperand().equals("scala/util/Random") && this.getNameConstantOperand().equals("<init>")) {
            this.reportBug("scala.util.Random", PREDICTABLE_RANDOM_SCALA_TYPE);
        } else if (seen == 182 && RANDOM_NEXT_METHODS.matches(this)) {
            this.reportBug("scala.util.Random." + this.getNameConstantOperand() + "()", PREDICTABLE_RANDOM_SCALA_TYPE);
        } else if (seen == 183 && this.getClassConstantOperand().equals("org/apache/commons/lang/math/JVMRandom") && this.getNameConstantOperand().equals("<init>")) {
            this.reportBug("org.apache.commons.lang.math.JVMRandom", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 184 && this.getClassConstantOperand().equals("org/apache/commons/lang/math/JVMRandom") && this.getNameConstantOperand().equals("nextLong")) {
            this.reportBug("org.apache.commons.lang.math.JVMRandom.nextLong()", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 184 && RANDOM_UTILS_METHODS.matches(this)) {
            this.reportBug("org.apache.commons.lang.math.RandomUtils" + this.getNameConstantOperand() + "()", PREDICTABLE_RANDOM_TYPE);
        } else if (seen == 184 && RANDOM_STRING_UTILS_METHODS.matches(this)) {
            this.reportBug("org.apache.commons.lang.RandomStringUtils" + this.getNameConstantOperand() + "()", PREDICTABLE_RANDOM_TYPE);
        }
    }
}

