/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection;

import com.h3xstream.findsecbugs.taintanalysis.TaintDataflow;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public abstract class AbstractTaintDetector
implements Detector {
    protected final BugReporter bugReporter;

    protected AbstractTaintDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public boolean shouldAnalyzeClass(ClassContext classContext) {
        return true;
    }

    public void visitClassContext(ClassContext classContext) {
        if (!this.shouldAnalyzeClass(classContext)) {
            return;
        }
        for (Method method : classContext.getMethodsInCallOrder()) {
            if (classContext.getMethodGen(method) == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CheckedAnalysisException e) {
                this.logException(classContext, method, (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.logException(classContext, method, e);
            }
        }
    }

    public void report() {
    }

    protected void analyzeMethod(ClassContext classContext, Method method) throws CheckedAnalysisException {
        TaintDataflow dataflow = AbstractTaintDetector.getTaintDataFlow(classContext, method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        String currentMethod = AbstractTaintDetector.getFullMethodName(classContext.getMethodGen(method));
        Iterator<Location> i = AbstractTaintDetector.getLocationIterator(classContext, method);
        while (i.hasNext()) {
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction instruction = handle.getInstruction();
            if (!(instruction instanceof InvokeInstruction)) continue;
            InvokeInstruction invoke = (InvokeInstruction)instruction;
            TaintFrame fact = (TaintFrame)((Object)dataflow.getFactAtLocation(location));
            assert (fact != null);
            if (!fact.isValid()) continue;
            this.analyzeLocation(classContext, method, handle, cpg, invoke, fact, currentMethod);
        }
    }

    private static Iterator<Location> getLocationIterator(ClassContext classContext, Method method) throws CheckedAnalysisException {
        try {
            return classContext.getCFG(method).locationIterator();
        }
        catch (CFGBuilderException ex) {
            throw new CheckedAnalysisException("cannot get control flow graph", (Throwable)ex);
        }
    }

    private static TaintDataflow getTaintDataFlow(ClassContext classContext, Method method) throws CheckedAnalysisException {
        MethodDescriptor descriptor = BCELUtil.getMethodDescriptor((JavaClass)classContext.getJavaClass(), (Method)method);
        return (TaintDataflow)((Object)Global.getAnalysisCache().getMethodAnalysis(TaintDataflow.class, descriptor));
    }

    private static String getFullMethodName(MethodGen methodGen) {
        String methodNameWithSignature = methodGen.getName() + methodGen.getSignature();
        String slashedClassName = methodGen.getClassName().replace('.', '/');
        return slashedClassName + "." + methodNameWithSignature;
    }

    private void logException(ClassContext classContext, Method method, Exception ex) {
        this.bugReporter.logError("Exception while analyzing " + classContext.getFullyQualifiedMethodName(method), (Throwable)ex);
    }

    protected abstract void analyzeLocation(ClassContext var1, Method var2, InstructionHandle var3, ConstantPoolGen var4, InvokeInstruction var5, TaintFrame var6, String var7) throws DataflowAnalysisException;
}

