/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xss;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.InterfaceUtils;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.ClassContext;

public class XssJspDetector
extends BasicInjectionDetector {
    private static final String XSS_JSP_PRINT_TYPE = "XSS_JSP_PRINT";
    public static final String[] JSP_PARENT_CLASSES = new String[]{"org.apache.jasper.runtime.HttpJspBase", "weblogic.servlet.jsp.JspBase"};

    public XssJspDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("xss-jsp.txt", XSS_JSP_PRINT_TYPE);
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe() && taint.hasTag(Taint.Tag.XSS_SAFE)) {
            if (FindSecBugsGlobalConfig.getInstance().isReportPotentialXssWrongContext()) {
                return 3;
            }
            return 5;
        }
        if (!taint.isSafe() && taint.hasOneTag(Taint.Tag.QUOTE_ENCODED, Taint.Tag.APOSTROPHE_ENCODED) && taint.hasTag(Taint.Tag.LT_ENCODED)) {
            return 3;
        }
        return super.getPriority(taint);
    }

    @Override
    public boolean shouldAnalyzeClass(ClassContext classContext) {
        String className = classContext.getClassDescriptor().getDottedClassName();
        return InterfaceUtils.isSubtype(className, JSP_PARENT_CLASSES);
    }
}

