/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.PlanExecutor;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.map.MetadataResolver;
import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.WatermarkKeysAssigner;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRules;
import com.hazelcast.jet.sql.impl.opt.logical.SelectByKeyMapLogicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.AssignDiscriminatorToScansRule;
import com.hazelcast.jet.sql.impl.opt.physical.CalcLimitTransposeRule;
import com.hazelcast.jet.sql.impl.opt.physical.CreateTopLevelDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.DeleteByKeyMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.DeletePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.InsertMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRules;
import com.hazelcast.jet.sql.impl.opt.physical.RootRel;
import com.hazelcast.jet.sql.impl.opt.physical.SelectByKeyMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ShouldNotExecuteRel;
import com.hazelcast.jet.sql.impl.opt.physical.SinkMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.UpdateByKeyMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.UpdatePhysicalRel;
import com.hazelcast.jet.sql.impl.parse.QueryConvertResult;
import com.hazelcast.jet.sql.impl.parse.QueryParseResult;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlCreateIndex;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlCreateType;
import com.hazelcast.jet.sql.impl.parse.SqlCreateView;
import com.hazelcast.jet.sql.impl.parse.SqlDropDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlDropIndex;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropType;
import com.hazelcast.jet.sql.impl.parse.SqlDropView;
import com.hazelcast.jet.sql.impl.parse.SqlExplainStatement;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.DataConnectionResolver;
import com.hazelcast.jet.sql.impl.schema.DataConnectionStorage;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.jet.sql.impl.schema.TypeDefinitionColumn;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.shaded.org.apache.calcite.plan.Contexts;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCostImpl;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelShuttleImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlString;
import com.hazelcast.shaded.org.apache.calcite.tools.RuleSets;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.optimizer.SqlOptimizer;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CalciteSqlOptimizer
implements SqlOptimizer {
    private final NodeEngine nodeEngine;
    private final SqlConnectorCache connectorCache;
    private final IMapResolver iMapResolver;
    private final List<TableResolver> tableResolvers;
    private final PlanExecutor planExecutor;
    private final RelationsStorage relationsStorage;
    private final DataConnectionStorage dataConnectionStorage;
    private final ILogger logger;

    public CalciteSqlOptimizer(NodeEngine nodeEngine, QueryResultRegistry resultRegistry) {
        this.nodeEngine = nodeEngine;
        this.connectorCache = new SqlConnectorCache(nodeEngine);
        this.iMapResolver = new MetadataResolver(nodeEngine);
        this.relationsStorage = new RelationsStorage(nodeEngine);
        this.dataConnectionStorage = new DataConnectionStorage(nodeEngine);
        TableResolverImpl tableResolverImpl = CalciteSqlOptimizer.mappingCatalog(nodeEngine, this.relationsStorage, this.connectorCache);
        DataConnectionResolver dataConnectionResolver = CalciteSqlOptimizer.dataConnectionCatalog(nodeEngine.getDataConnectionService(), this.dataConnectionStorage, nodeEngine.getHazelcastInstance().getConfig().getSecurityConfig().isEnabled());
        this.tableResolvers = Arrays.asList(tableResolverImpl, dataConnectionResolver);
        this.planExecutor = new PlanExecutor(nodeEngine, tableResolverImpl, dataConnectionResolver, resultRegistry);
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    private static TableResolverImpl mappingCatalog(NodeEngine nodeEngine, RelationsStorage relationsStorage, SqlConnectorCache connectorCache) {
        return new TableResolverImpl(nodeEngine, relationsStorage, connectorCache);
    }

    private static DataConnectionResolver dataConnectionCatalog(InternalDataConnectionService dataConnectionService, DataConnectionStorage storage, boolean isSecurityEnabled) {
        return new DataConnectionResolver(dataConnectionService, storage, isSecurityEnabled);
    }

    @Override
    @Nullable
    public String mappingDdl(String name) {
        Mapping mapping = this.iMapResolver.resolve(name);
        return mapping != null ? SqlCreateMapping.unparse(mapping) : null;
    }

    @Override
    public List<TableResolver> tableResolvers() {
        return this.tableResolvers;
    }

    public RelationsStorage relationsStorage() {
        return this.relationsStorage;
    }

    public PlanExecutor getPlanExecutor() {
        return this.planExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlPlan prepare(OptimizationTask task) {
        int memberCount = this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR);
        OptimizerContext context = OptimizerContext.create(task.getSchema(), task.getSearchPaths(), task.getArguments(), memberCount, this.iMapResolver);
        try {
            OptimizerContext.setThreadContext(context);
            QueryParseResult parseResult = context.parse(task.getSql());
            SqlPlan sqlPlan = this.createPlan(task, parseResult, context);
            return sqlPlan;
        }
        finally {
            OptimizerContext.setThreadContext(null);
        }
    }

    private SqlPlan createPlan(OptimizationTask task, QueryParseResult parseResult, OptimizerContext context) {
        SqlNode node = parseResult.getNode();
        PlanKey planKey = new PlanKey(task.getSearchPaths(), task.getSql());
        if (node instanceof SqlCreateMapping) {
            return this.toCreateMappingPlan(planKey, (SqlCreateMapping)node);
        }
        if (node instanceof SqlDropMapping) {
            return this.toDropMappingPlan(planKey, (SqlDropMapping)node);
        }
        if (node instanceof SqlCreateIndex) {
            return this.toCreateIndexPlan(planKey, (SqlCreateIndex)node);
        }
        if (node instanceof SqlDropIndex) {
            return this.toDropIndexPlan(planKey, (SqlDropIndex)node);
        }
        if (node instanceof SqlCreateDataConnection) {
            return this.toCreateDataConnectionPlan(planKey, (SqlCreateDataConnection)node);
        }
        if (node instanceof SqlDropDataConnection) {
            return this.toDropDataConnectionPlan(planKey, (SqlDropDataConnection)node);
        }
        if (node instanceof SqlCreateJob) {
            return this.toCreateJobPlan(planKey, parseResult, context, task.getSql());
        }
        if (node instanceof SqlAlterJob) {
            return this.toAlterJobPlan(planKey, (SqlAlterJob)node);
        }
        if (node instanceof SqlDropJob) {
            return this.toDropJobPlan(planKey, (SqlDropJob)node);
        }
        if (node instanceof SqlCreateSnapshot) {
            return this.toCreateSnapshotPlan(planKey, (SqlCreateSnapshot)node);
        }
        if (node instanceof SqlDropSnapshot) {
            return this.toDropSnapshotPlan(planKey, (SqlDropSnapshot)node);
        }
        if (node instanceof SqlCreateView) {
            return this.toCreateViewPlan(planKey, context, (SqlCreateView)node);
        }
        if (node instanceof SqlDropView) {
            return this.toDropViewPlan(planKey, (SqlDropView)node);
        }
        if (node instanceof SqlDropType) {
            return this.toDropTypePlan(planKey, (SqlDropType)node);
        }
        if (node instanceof SqlShowStatement) {
            return this.toShowStatementPlan(planKey, (SqlShowStatement)node);
        }
        if (node instanceof SqlExplainStatement) {
            return this.toExplainStatementPlan(planKey, context, parseResult);
        }
        if (node instanceof SqlCreateType) {
            return this.toCreateTypePlan(planKey, (SqlCreateType)node);
        }
        QueryConvertResult convertResult = context.convert(parseResult.getNode());
        return this.toPlan(planKey, parseResult.getParameterMetadata(), convertResult.getRel(), convertResult.getFieldNames(), context, false, task.getSql());
    }

    private SqlPlan toCreateMappingPlan(PlanKey planKey, SqlCreateMapping node) {
        List<MappingField> mappingFields = node.columns().map(field -> new MappingField(field.name(), field.type(), field.externalName())).collect(Collectors.toList());
        if (this.nodeEngine.getVersion().asVersion().isLessThan(Versions.V5_3) && (node.dataConnectionNameWithoutSchema() != null || node.objectType() != null)) {
            throw new HazelcastException("Cannot create a mapping with a data connection or an object type until the cluster is upgraded to 5.3");
        }
        Mapping mapping = new Mapping(node.nameWithoutSchema(), node.externalName(), node.dataConnectionNameWithoutSchema(), node.connectorType(), node.objectType(), mappingFields, node.options());
        return new SqlPlanImpl.CreateMappingPlan(planKey, mapping, node.getReplace(), node.ifNotExists(), this.planExecutor);
    }

    private SqlPlan toCreateDataConnectionPlan(PlanKey planKey, SqlCreateDataConnection sqlCreateDataConnection) {
        return new SqlPlanImpl.CreateDataConnectionPlan(planKey, sqlCreateDataConnection.getReplace(), sqlCreateDataConnection.ifNotExists, sqlCreateDataConnection.nameWithoutSchema(), sqlCreateDataConnection.type(), sqlCreateDataConnection.shared(), sqlCreateDataConnection.options(), this.planExecutor);
    }

    private SqlPlan toDropDataConnectionPlan(PlanKey planKey, SqlDropDataConnection sqlDropDataConnection) {
        return new SqlPlanImpl.DropDataConnectionPlan(planKey, sqlDropDataConnection.name(), sqlDropDataConnection.ifExists(), this.planExecutor);
    }

    private SqlPlan toDropMappingPlan(PlanKey planKey, SqlDropMapping sqlDropMapping) {
        return new SqlPlanImpl.DropMappingPlan(planKey, sqlDropMapping.nameWithoutSchema(), sqlDropMapping.ifExists(), this.planExecutor);
    }

    private SqlPlan toCreateIndexPlan(PlanKey planKey, SqlCreateIndex sqlCreateIndex) {
        return new SqlPlanImpl.CreateIndexPlan(planKey, sqlCreateIndex.indexName(), sqlCreateIndex.mapName(), sqlCreateIndex.type(), sqlCreateIndex.columns(), sqlCreateIndex.options(), sqlCreateIndex.ifNotExists(), this.planExecutor);
    }

    private SqlPlan toDropIndexPlan(PlanKey planKey, SqlDropIndex sqlDropIndex) {
        return new SqlPlanImpl.DropIndexPlan(planKey, sqlDropIndex.indexName(), sqlDropIndex.ifExists(), this.planExecutor);
    }

    private SqlPlan toCreateJobPlan(PlanKey planKey, QueryParseResult parseResult, OptimizerContext context, String query) {
        SqlCreateJob sqlCreateJob = (SqlCreateJob)parseResult.getNode();
        SqlExtendedInsert source = sqlCreateJob.dmlStatement();
        QueryParseResult dmlParseResult = new QueryParseResult(source, parseResult.getParameterMetadata());
        QueryConvertResult dmlConvertedResult = context.convert(dmlParseResult.getNode());
        SqlPlanImpl dmlPlan = this.toPlan(null, parseResult.getParameterMetadata(), dmlConvertedResult.getRel(), dmlConvertedResult.getFieldNames(), context, true, query);
        assert (dmlPlan instanceof SqlPlanImpl.DmlPlan && ((SqlPlanImpl.DmlPlan)dmlPlan).getOperation() == TableModify.Operation.INSERT);
        return new SqlPlanImpl.CreateJobPlan(planKey, sqlCreateJob.jobConfig(), sqlCreateJob.ifNotExists(), (SqlPlanImpl.DmlPlan)dmlPlan, query, ((SqlPlanImpl.DmlPlan)dmlPlan).isInfiniteRows(), this.planExecutor);
    }

    private SqlPlan toAlterJobPlan(PlanKey planKey, SqlAlterJob sqlAlterJob) {
        return new SqlPlanImpl.AlterJobPlan(planKey, sqlAlterJob.name(), sqlAlterJob.getDeltaConfig(), sqlAlterJob.getOperation(), this.planExecutor);
    }

    private SqlPlan toDropJobPlan(PlanKey planKey, SqlDropJob sqlDropJob) {
        return new SqlPlanImpl.DropJobPlan(planKey, sqlDropJob.name(), sqlDropJob.ifExists(), sqlDropJob.withSnapshotName(), this.planExecutor);
    }

    private SqlPlan toCreateSnapshotPlan(PlanKey planKey, SqlCreateSnapshot sqlNode) {
        return new SqlPlanImpl.CreateSnapshotPlan(planKey, sqlNode.getSnapshotName(), sqlNode.getJobName(), this.planExecutor);
    }

    private SqlPlan toDropSnapshotPlan(PlanKey planKey, SqlDropSnapshot sqlNode) {
        return new SqlPlanImpl.DropSnapshotPlan(planKey, sqlNode.getSnapshotName(), sqlNode.isIfExists(), this.planExecutor);
    }

    private SqlPlan toCreateViewPlan(PlanKey planKey, OptimizerContext context, SqlCreateView sqlNode) {
        SqlString sqlString = sqlNode.getQuery().toSqlString(PostgresqlSqlDialect.DEFAULT);
        String sql = sqlString.getSql();
        boolean replace = sqlNode.getReplace();
        boolean ifNotExists = sqlNode.ifNotExists;
        return new SqlPlanImpl.CreateViewPlan(planKey, context, sqlNode.name(), sql, replace, ifNotExists, this.planExecutor);
    }

    private SqlPlan toDropViewPlan(PlanKey planKey, SqlDropView sqlNode) {
        return new SqlPlanImpl.DropViewPlan(planKey, sqlNode.viewName(), sqlNode.ifExists(), this.planExecutor);
    }

    private SqlPlan toDropTypePlan(PlanKey planKey, SqlDropType sqlNode) {
        return new SqlPlanImpl.DropTypePlan(planKey, sqlNode.typeName(), sqlNode.ifExists(), this.planExecutor);
    }

    private SqlPlan toShowStatementPlan(PlanKey planKey, SqlShowStatement sqlNode) {
        return new SqlPlanImpl.ShowStatementPlan(planKey, sqlNode.getTarget(), sqlNode.getDataConnectionNameWithoutSchema(), this.planExecutor);
    }

    private SqlPlan toExplainStatementPlan(PlanKey planKey, OptimizerContext context, QueryParseResult parseResult) {
        SqlNode node = parseResult.getNode();
        assert (node instanceof SqlExplainStatement);
        QueryConvertResult convertResult = context.convert(((SqlExplainStatement)node).getExplicandum());
        PhysicalRel physicalRel = this.optimize(parseResult.getParameterMetadata(), convertResult.getRel(), context, false);
        return new SqlPlanImpl.ExplainStatementPlan(planKey, physicalRel, this.planExecutor);
    }

    private SqlPlan toCreateTypePlan(PlanKey planKey, SqlCreateType sqlNode) {
        List<TypeDefinitionColumn> columns = sqlNode.columns().map(column -> new TypeDefinitionColumn(column.name(), column.type())).collect(Collectors.toList());
        return new SqlPlanImpl.CreateTypePlan(planKey, sqlNode.typeName(), sqlNode.getReplace(), sqlNode.ifNotExists(), columns, sqlNode.options(), this.planExecutor);
    }

    private SqlPlanImpl toPlan(PlanKey planKey, QueryParameterMetadata parameterMetadata, RelNode rel, List<String> fieldNames, OptimizerContext context, boolean isCreateJob, String query) {
        PhysicalRel physicalRel = this.optimize(parameterMetadata, rel, context, isCreateJob);
        List<Permission> permissions = this.extractPermissions(physicalRel);
        if (physicalRel instanceof SelectByKeyMapPhysicalRel) {
            assert (!isCreateJob);
            SelectByKeyMapPhysicalRel select = (SelectByKeyMapPhysicalRel)physicalRel;
            SqlRowMetadata rowMetadata = this.createRowMetadata(fieldNames, physicalRel.schema(parameterMetadata).getTypes(), rel.getRowType().getFieldList());
            return new SqlPlanImpl.IMapSelectPlan(planKey, select.objectKey(), parameterMetadata, select.mapName(), select.keyCondition(parameterMetadata), select.rowProjectorSupplier(parameterMetadata), rowMetadata, this.planExecutor, permissions);
        }
        if (physicalRel instanceof InsertMapPhysicalRel) {
            assert (!isCreateJob);
            InsertMapPhysicalRel insert = (InsertMapPhysicalRel)physicalRel;
            return new SqlPlanImpl.IMapInsertPlan(planKey, insert.objectKey(), parameterMetadata, insert.mapName(), insert.entriesFn(), this.planExecutor, permissions, insert.keyParamIndex());
        }
        if (physicalRel instanceof SinkMapPhysicalRel) {
            assert (!isCreateJob);
            SinkMapPhysicalRel sink = (SinkMapPhysicalRel)physicalRel;
            return new SqlPlanImpl.IMapSinkPlan(planKey, sink.objectKey(), parameterMetadata, sink.mapName(), sink.entriesFn(), this.planExecutor, permissions);
        }
        if (physicalRel instanceof UpdateByKeyMapPhysicalRel) {
            assert (!isCreateJob);
            UpdateByKeyMapPhysicalRel update = (UpdateByKeyMapPhysicalRel)physicalRel;
            return new SqlPlanImpl.IMapUpdatePlan(planKey, update.objectKey(), parameterMetadata, update.mapName(), update.keyCondition(parameterMetadata), update.updaterSupplier(parameterMetadata), this.planExecutor, permissions);
        }
        if (physicalRel instanceof UpdatePhysicalRel) {
            this.checkDmlOperationWithView(physicalRel);
            Tuple2<DAG, Set<PlanObjectKey>> dagAndKeys = this.createDag(physicalRel, parameterMetadata, context.getUsedViews());
            return new SqlPlanImpl.DmlPlan(TableModify.Operation.UPDATE, planKey, parameterMetadata, (Set)dagAndKeys.f1(), (DAG)dagAndKeys.f0(), query, OptUtils.isUnbounded(physicalRel), this.planExecutor, permissions);
        }
        if (physicalRel instanceof DeleteByKeyMapPhysicalRel) {
            assert (!isCreateJob);
            DeleteByKeyMapPhysicalRel delete = (DeleteByKeyMapPhysicalRel)physicalRel;
            return new SqlPlanImpl.IMapDeletePlan(planKey, delete.objectKey(), parameterMetadata, delete.mapName(), delete.keyCondition(parameterMetadata), this.planExecutor, permissions);
        }
        if (physicalRel instanceof TableModify) {
            this.checkDmlOperationWithView(physicalRel);
            TableModify.Operation operation = ((TableModify)((Object)physicalRel)).getOperation();
            Tuple2<DAG, Set<PlanObjectKey>> dagAndKeys = this.createDag(physicalRel, parameterMetadata, context.getUsedViews());
            return new SqlPlanImpl.DmlPlan(operation, planKey, parameterMetadata, (Set)dagAndKeys.f1(), (DAG)dagAndKeys.f0(), query, OptUtils.isUnbounded(physicalRel), this.planExecutor, permissions);
        }
        if (physicalRel instanceof DeletePhysicalRel) {
            this.checkDmlOperationWithView(physicalRel);
            Tuple2<DAG, Set<PlanObjectKey>> dagAndKeys = this.createDag(physicalRel, parameterMetadata, context.getUsedViews());
            return new SqlPlanImpl.DmlPlan(TableModify.Operation.DELETE, planKey, parameterMetadata, (Set)dagAndKeys.f1(), (DAG)dagAndKeys.f0(), query, OptUtils.isUnbounded(physicalRel), this.planExecutor, permissions);
        }
        Tuple2<DAG, Set<PlanObjectKey>> dagAndKeys = this.createDag(new RootRel(physicalRel), parameterMetadata, context.getUsedViews());
        SqlRowMetadata rowMetadata = this.createRowMetadata(fieldNames, physicalRel.schema(parameterMetadata).getTypes(), rel.getRowType().getFieldList());
        return new SqlPlanImpl.SelectPlan(planKey, parameterMetadata, (Set)dagAndKeys.f1(), (DAG)dagAndKeys.f0(), query, OptUtils.isUnbounded(physicalRel), rowMetadata, this.planExecutor, permissions);
    }

    private List<Permission> extractPermissions(PhysicalRel physicalRel) {
        final ArrayList<Permission> permissions = new ArrayList<Permission>();
        physicalRel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                this.addPermissionForTable(scan.getTable(), "read");
                return super.visit(scan);
            }

            @Override
            public RelNode visit(RelNode other) {
                this.addPermissionForTable(other.getTable(), "put");
                return super.visit(other);
            }

            private void addPermissionForTable(RelOptTable t2, String action) {
                if (t2 == null) {
                    return;
                }
                HazelcastTable table = t2.unwrap(HazelcastTable.class);
                if (table != null && table.getTarget() instanceof AbstractMapTable) {
                    String mapName = ((AbstractMapTable)table.getTarget()).getMapName();
                    permissions.add(new MapPermission(mapName, new String[]{action}));
                }
            }
        });
        return permissions;
    }

    private PhysicalRel optimize(QueryParameterMetadata parameterMetadata, RelNode rel, OptimizerContext context, boolean isCreateJob) {
        context.setParameterMetadata(parameterMetadata);
        context.setRequiresJob(isCreateJob);
        boolean fineLogOn = this.logger.isFineEnabled();
        if (fineLogOn) {
            this.logger.fine("Before logical opt:\n" + RelOptUtil.toString(rel));
        }
        LogicalRel logicalRel = this.optimizeLogical(context, rel);
        if (fineLogOn) {
            this.logger.fine("After logical opt:\n" + RelOptUtil.toString(logicalRel));
        }
        LogicalRel logicalRel2 = this.optimizeIMapKeyedAccess(context, logicalRel);
        if (fineLogOn && logicalRel != logicalRel2) {
            this.logger.fine("After IMap keyed access opt:\n" + RelOptUtil.toString(logicalRel2));
        }
        PhysicalRel physicalRel = this.optimizePhysical(context, logicalRel2);
        physicalRel = CalciteSqlOptimizer.postOptimizationRewrites(physicalRel);
        if (fineLogOn) {
            this.logger.fine("After physical opt:\n" + RelOptUtil.toString(physicalRel));
        }
        return physicalRel;
    }

    private LogicalRel optimizeLogical(OptimizerContext context, RelNode rel) {
        return (LogicalRel)context.optimize(rel, LogicalRules.getRuleSet(), OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    private LogicalRel optimizeIMapKeyedAccess(OptimizerContext context, LogicalRel rel) {
        if (!(rel instanceof FullScanLogicalRel)) {
            return rel;
        }
        return (LogicalRel)context.optimize(rel, RuleSets.ofList(SelectByKeyMapLogicalRule.INSTANCE), OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    private PhysicalRel optimizePhysical(OptimizerContext context, RelNode rel) {
        return (PhysicalRel)context.optimize(rel, PhysicalRules.getRuleSet(), OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    public static PhysicalRel postOptimizationRewrites(PhysicalRel rel) {
        HepProgramBuilder hepProgramBuilder = new HepProgramBuilder();
        AssignDiscriminatorToScansRule assignDiscriminatorRule = new AssignDiscriminatorToScansRule();
        hepProgramBuilder.addRuleInstance(assignDiscriminatorRule);
        hepProgramBuilder.addRuleInstance(CalcLimitTransposeRule.INSTANCE);
        HepPlanner planner = new HepPlanner(hepProgramBuilder.build(), Contexts.empty(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(rel);
        return (PhysicalRel)planner.findBestExp();
    }

    private SqlRowMetadata createRowMetadata(List<String> columnNames, List<QueryDataType> columnTypes, List<RelDataTypeField> fields) {
        assert (columnNames.size() == columnTypes.size());
        assert (columnTypes.size() == fields.size());
        ArrayList<SqlColumnMetadata> columns = new ArrayList<SqlColumnMetadata>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            SqlColumnMetadata column = QueryUtils.getColumnMetadata(columnNames.get(i), columnTypes.get(i), fields.get(i).getType().isNullable());
            columns.add(column);
        }
        return new SqlRowMetadata(columns);
    }

    private Tuple2<DAG, Set<PlanObjectKey>> createDag(PhysicalRel physicalRel, QueryParameterMetadata parameterMetadata, Set<PlanObjectKey> usedViews) {
        String exceptionMessage = new ExecutionStopperFinder(physicalRel).find();
        if (exceptionMessage != null) {
            throw QueryException.error((String)exceptionMessage);
        }
        WatermarkKeysAssigner wmKeysAssigner = new WatermarkKeysAssigner(physicalRel);
        wmKeysAssigner.assignWatermarkKeys();
        this.logger.finest("Watermark keys assigned");
        CreateTopLevelDagVisitor visitor = new CreateTopLevelDagVisitor(this.nodeEngine, parameterMetadata, wmKeysAssigner, usedViews);
        physicalRel.accept(visitor);
        visitor.optimizeFinishedDag();
        return Tuple2.tuple2((Object)visitor.getDag(), visitor.getObjectKeys());
    }

    private void checkDmlOperationWithView(PhysicalRel rel) {
        HazelcastTable table = Objects.requireNonNull(rel.getTable()).unwrap(HazelcastTable.class);
        if (table.getTarget() instanceof ViewTable) {
            throw QueryException.error((String)"DML operations not supported for views");
        }
    }

    static class ExecutionStopperFinder
    extends RelVisitor {
        private final RelNode rootRel;
        private String message;

        ExecutionStopperFinder(RelNode rootRel) {
            this.rootRel = rootRel;
        }

        @Override
        public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
            if (node instanceof ShouldNotExecuteRel) {
                this.message = ((ShouldNotExecuteRel)node).message();
                return;
            }
            super.visit(node, ordinal, parent);
        }

        private String find() {
            this.go(this.rootRel);
            return this.message;
        }
    }
}

