/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static ComparatorEx<JetSqlRow> comparisonFn(@Nonnull List<FieldCollation> fieldCollationList) {
        return new SqlRowComparator(fieldCollationList);
    }

    public static FunctionEx<JetSqlRow, JetSqlRow> projectionFn(@Nonnull List<Expression<?>> projections, @Nonnull ExpressionEvalContext context) {
        return (FunctionEx & Serializable)row0 -> ExpressionUtil.projection(projections, context, row0.getRow());
    }

    public static FunctionEx<JetSqlRow, JetSqlRow> calcFn(@Nonnull List<Expression<?>> projections, @Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        return (FunctionEx & Serializable)row0 -> ExpressionUtil.projection(predicate, projections, row0.getRow(), context);
    }

    @Nullable
    public static JetSqlRow join(@Nonnull JetSqlRow leftRow, @Nonnull JetSqlRow rightRow, @Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        Object[] joined = Arrays.copyOf(leftRow.getValues(), leftRow.getFieldCount() + rightRow.getFieldCount());
        System.arraycopy(rightRow.getValues(), 0, joined, leftRow.getFieldCount(), rightRow.getFieldCount());
        JetSqlRow result = new JetSqlRow((SerializationService)context.getSerializationService(), joined);
        Row row = result.getRow();
        return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context)) ? result : null;
    }

    @Nonnull
    public static List<JetSqlRow> evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull Stream<JetSqlRow> rows, @Nonnull ExpressionEvalContext context) {
        return rows.map(row -> ExpressionUtil.evaluate(predicate, projection, row, context)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static JetSqlRow evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull JetSqlRow values, @Nonnull ExpressionEvalContext context) {
        Row row = values.getRow();
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context))) {
            return null;
        }
        if (projection == null) {
            return values;
        }
        return ExpressionUtil.projection(projection, context, row);
    }

    @Nullable
    public static JetSqlRow projection(@Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projections, @Nonnull Row row, @Nonnull ExpressionEvalContext context) {
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context))) {
            return null;
        }
        return ExpressionUtil.projection(projections, context, row);
    }

    private static JetSqlRow projection(@Nonnull List<Expression<?>> projections, @Nonnull ExpressionEvalContext context, @Nonnull Row row) {
        Object[] result = new Object[projections.size()];
        for (int i = 0; i < projections.size(); ++i) {
            result[i] = ExpressionUtil.evaluate(projections.get(i), row, context);
        }
        return new JetSqlRow((SerializationService)context.getSerializationService(), result);
    }

    public static Object evaluate(@Nonnull Expression<?> expression, @Nonnull Row row, @Nonnull ExpressionEvalContext context) {
        return expression.evalTop(row, context);
    }

    public static class SqlRowComparator
    implements IdentifiedDataSerializable,
    ComparatorEx<JetSqlRow> {
        private List<FieldCollation> fieldCollationList;

        public SqlRowComparator() {
        }

        public SqlRowComparator(List<FieldCollation> fieldCollationList) {
            this.fieldCollationList = fieldCollationList;
        }

        public int compareEx(JetSqlRow row1, JetSqlRow row2) {
            for (FieldCollation fieldCollation : this.fieldCollationList) {
                int index = fieldCollation.getIndex();
                Comparable o1 = (Comparable)row1.get(index);
                Object o2 = row2.get(index);
                RelFieldCollation.Direction direction = fieldCollation.getDirection();
                int result = o1 == o2 ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : o1.compareTo(o2)));
                if (direction.isDescending()) {
                    if (result < 0) {
                        result = 1;
                    } else if (result > 0) {
                        result = -1;
                    }
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.fieldCollationList.size());
            for (FieldCollation fieldCollation : this.fieldCollationList) {
                out.writeObject((Object)fieldCollation);
            }
        }

        public void readData(ObjectDataInput in) throws IOException {
            int size = in.readInt();
            this.fieldCollationList = new ArrayList<FieldCollation>(size);
            for (int i = 0; i < size; ++i) {
                this.fieldCollationList.add((FieldCollation)in.readObject());
            }
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 9;
        }
    }
}

