/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.expression.Expression;
import java.io.IOException;
import java.util.Arrays;

public class JetJoinInfo
implements DataSerializable {
    private JoinRelType joinType;
    private int[] leftEquiJoinIndices;
    private int[] rightEquiJoinIndices;
    private Expression<Boolean> nonEquiCondition;
    private Expression<Boolean> condition;

    private JetJoinInfo() {
    }

    public JetJoinInfo(JoinRelType joinType, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, Expression<Boolean> nonEquiCondition, Expression<Boolean> condition) {
        Preconditions.checkTrue((leftEquiJoinIndices.length == rightEquiJoinIndices.length ? 1 : 0) != 0, (String)"indices length mismatch");
        this.joinType = joinType;
        this.leftEquiJoinIndices = leftEquiJoinIndices;
        this.rightEquiJoinIndices = rightEquiJoinIndices;
        this.nonEquiCondition = nonEquiCondition;
        this.condition = condition;
    }

    public boolean isInner() {
        return this.joinType == JoinRelType.INNER;
    }

    public boolean isLeftOuter() {
        return this.joinType == JoinRelType.LEFT;
    }

    public boolean isRightOuter() {
        return this.joinType == JoinRelType.RIGHT;
    }

    public int[] leftEquiJoinIndices() {
        return this.leftEquiJoinIndices;
    }

    public int[] rightEquiJoinIndices() {
        return this.rightEquiJoinIndices;
    }

    public Expression<Boolean> nonEquiCondition() {
        return this.nonEquiCondition;
    }

    public Expression<Boolean> condition() {
        return this.condition;
    }

    public boolean isEquiJoin() {
        return this.rightEquiJoinIndices.length > 0;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.joinType.name());
        out.writeObject((Object)this.leftEquiJoinIndices);
        out.writeObject((Object)this.rightEquiJoinIndices);
        out.writeObject(this.nonEquiCondition);
        out.writeObject(this.condition);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.joinType = JoinRelType.valueOf(in.readString());
        this.leftEquiJoinIndices = (int[])in.readObject();
        this.rightEquiJoinIndices = (int[])in.readObject();
        this.nonEquiCondition = (Expression)in.readObject();
        this.condition = (Expression)in.readObject();
    }

    public String toString() {
        return "JetJoinInfo{joinType=" + this.joinType.name() + ", leftEquiJoinIndices=" + Arrays.toString(this.leftEquiJoinIndices) + ", rightEquiJoinIndices=" + Arrays.toString(this.rightEquiJoinIndices) + ", nonEquiCondition=" + this.nonEquiCondition + ", condition=" + this.condition + '}';
    }

    public boolean isCooperative() {
        return !(this.condition != null && !this.condition.isCooperative() || this.nonEquiCondition != null && !this.nonEquiCondition.isCooperative());
    }
}

