/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.ResultLimitReachedException;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class QueryResultProducerImpl
implements QueryResultProducer {
    static final int QUEUE_CAPACITY = 4096;
    private static final Exception NORMAL_COMPLETION = new NormalCompletionException();
    private final boolean blockForNextItem;
    private final OneToOneConcurrentArrayQueue<JetSqlRow> rows = new OneToOneConcurrentArrayQueue(4096);
    private final AtomicReference<Exception> done = new AtomicReference();
    private InternalIterator iterator;
    private long limit = Long.MAX_VALUE;
    private long offset;

    public QueryResultProducerImpl(boolean blockForNextItem) {
        this.blockForNextItem = blockForNextItem;
    }

    public void init(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
    }

    @Override
    public ResultIterator<JetSqlRow> iterator() {
        if (this.iterator != null) {
            throw new IllegalStateException("Iterator can be requested only once");
        }
        this.iterator = new InternalIterator();
        return this.iterator;
    }

    @Override
    public void onError(QueryException error) {
        assert (error != null);
        this.done.compareAndSet(null, (Exception)((Object)error));
    }

    public void done() {
        this.done.compareAndSet(null, NORMAL_COMPLETION);
    }

    public void consume(Inbox inbox) {
        JetSqlRow row;
        this.ensureNotDone();
        if (this.limit <= 0L) {
            this.done.compareAndSet(null, (Exception)new ResultLimitReachedException());
            this.ensureNotDone();
        }
        while (this.offset > 0L && inbox.poll() != null) {
            --this.offset;
        }
        while ((row = (JetSqlRow)inbox.peek()) != null && this.rows.offer((Object)row)) {
            inbox.remove();
            if (this.limit == Long.MAX_VALUE) continue;
            --this.limit;
            if (this.limit >= 1L) continue;
            this.done.compareAndSet(null, (Exception)new ResultLimitReachedException());
            this.ensureNotDone();
        }
    }

    public void ensureNotDone() {
        Exception exception = this.done.get();
        if (exception != null) {
            throw ExceptionUtil.sneakyThrow((Throwable)exception);
        }
    }

    private static final class NormalCompletionException
    extends Exception {
        NormalCompletionException() {
            super("Done normally", null, false, false);
        }
    }

    private class InternalIterator
    implements ResultIterator<JetSqlRow> {
        private final IdleStrategy idler = new BackoffIdleStrategy(0L, 0L, TimeUnit.MICROSECONDS.toNanos(50L), TimeUnit.MILLISECONDS.toNanos(1L));
        private JetSqlRow nextRow;

        private InternalIterator() {
        }

        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            if (QueryResultProducerImpl.this.blockForNextItem) {
                return this.hasNext() ? ResultIterator.HasNextResult.YES : ResultIterator.HasNextResult.DONE;
            }
            return this.nextRow != null || (this.nextRow = (JetSqlRow)QueryResultProducerImpl.this.rows.poll()) != null ? ResultIterator.HasNextResult.YES : (this.isDone() ? ResultIterator.HasNextResult.DONE : (timeout == 0L ? ResultIterator.HasNextResult.TIMEOUT : this.hasNextWait(System.nanoTime() + timeUnit.toNanos(timeout))));
        }

        public boolean hasNext() {
            return this.hasNextWait(Long.MAX_VALUE) == ResultIterator.HasNextResult.YES;
        }

        public JetSqlRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                JetSqlRow jetSqlRow = this.nextRow;
                return jetSqlRow;
            }
            finally {
                this.nextRow = (JetSqlRow)QueryResultProducerImpl.this.rows.poll();
            }
        }

        private ResultIterator.HasNextResult hasNextWait(long endTimeNanos) {
            long idleCount = 0L;
            do {
                if (this.nextRow != null || (this.nextRow = (JetSqlRow)QueryResultProducerImpl.this.rows.poll()) != null) {
                    return ResultIterator.HasNextResult.YES;
                }
                if (this.isDone()) {
                    return ResultIterator.HasNextResult.DONE;
                }
                this.idler.idle(++idleCount);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new RuntimeException(new InterruptedException("thread interrupted"));
            } while (System.nanoTime() < endTimeNanos);
            return ResultIterator.HasNextResult.TIMEOUT;
        }

        private boolean isDone() {
            Exception exception = (Exception)QueryResultProducerImpl.this.done.get();
            if (exception != null) {
                if (exception instanceof NormalCompletionException || exception instanceof ResultLimitReachedException) {
                    return QueryResultProducerImpl.this.rows.isEmpty();
                }
                throw ExceptionUtil.sneakyThrow((Throwable)exception);
            }
            return false;
        }
    }
}

