/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface SqlConnector {
    public static final String OPTION_FORMAT = "format";
    public static final String OPTION_KEY_FORMAT = "keyFormat";
    public static final String OPTION_VALUE_FORMAT = "valueFormat";
    public static final String OPTION_KEY_CLASS = "keyJavaClass";
    public static final String OPTION_VALUE_CLASS = "valueJavaClass";
    public static final String OPTION_KEY_FACTORY_ID = "keyPortableFactoryId";
    public static final String OPTION_KEY_CLASS_ID = "keyPortableClassId";
    public static final String OPTION_KEY_CLASS_VERSION = "keyPortableClassVersion";
    public static final String OPTION_VALUE_FACTORY_ID = "valuePortableFactoryId";
    public static final String OPTION_VALUE_CLASS_ID = "valuePortableClassId";
    public static final String OPTION_VALUE_CLASS_VERSION = "valuePortableClassVersion";
    public static final String OPTION_KEY_COMPACT_TYPE_NAME = "keyCompactTypeName";
    public static final String OPTION_VALUE_COMPACT_TYPE_NAME = "valueCompactTypeName";
    public static final String OPTION_TYPE_JAVA_CLASS = "javaClass";
    public static final String OPTION_TYPE_COMPACT_TYPE_NAME = "compactTypeName";
    public static final String OPTION_TYPE_PORTABLE_FACTORY_ID = "portableFactoryId";
    public static final String OPTION_TYPE_PORTABLE_CLASS_ID = "portableClassId";
    public static final String OPTION_TYPE_PORTABLE_CLASS_VERSION = "portableClassVersion";
    public static final String JAVA_FORMAT = "java";
    public static final String PORTABLE_FORMAT = "portable";
    public static final String COMPACT_FORMAT = "compact";
    public static final String JSON_FLAT_FORMAT = "json-flat";
    public static final String CSV_FORMAT = "csv";
    public static final String AVRO_FORMAT = "avro";
    public static final String PARQUET_FORMAT = "parquet";

    public String typeName();

    @Nonnull
    public String defaultObjectType();

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine var1, @Nonnull SqlExternalResource var2, @Nonnull List<MappingField> var3);

    @Nonnull
    public Table createTable(@Nonnull NodeEngine var1, @Nonnull String var2, @Nonnull String var3, @Nonnull SqlExternalResource var4, @Nonnull List<MappingField> var5);

    @Nonnull
    default public Vertex fullScanReader(@Nonnull DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        throw new UnsupportedOperationException("Full scan not supported for " + this.typeName());
    }

    @Nonnull
    default public VertexWithInputConfig nestedLoopReader(@Nonnull DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nonnull JetJoinInfo joinInfo) {
        throw new UnsupportedOperationException("Nested-loop join not supported for " + this.typeName());
    }

    default public boolean isNestedLoopReaderSupported() {
        try {
            Method m4 = this.getClass().getMethod("nestedLoopReader", DagBuildContext.class, HazelcastRexNode.class, List.class, JetJoinInfo.class);
            return m4.getDeclaringClass() != SqlConnector.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    default public VertexWithInputConfig insertProcessor(@Nonnull DagBuildContext context) {
        throw new UnsupportedOperationException("INSERT INTO not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex sinkProcessor(@Nonnull DagBuildContext context) {
        throw new UnsupportedOperationException("SINK INTO not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex updateProcessor(@Nonnull DagBuildContext context, @Nonnull List<String> fieldNames, @Nonnull List<HazelcastRexNode> expressions, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        throw new UnsupportedOperationException("UPDATE not supported for " + this.typeName());
    }

    @Nonnull
    default public Vertex deleteProcessor(@Nonnull DagBuildContext context, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        throw new UnsupportedOperationException("DELETE not supported for " + this.typeName());
    }

    default public boolean dmlSupportsPredicates() {
        return true;
    }

    default public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return expression.unwrap(RexNode.class) instanceof RexDynamicParam;
    }

    @Nonnull
    default public List<String> getPrimaryKey(Table table) {
        throw new UnsupportedOperationException("PRIMARY KEY not supported by connector: " + this.typeName());
    }

    public static class SqlExternalResource
    implements Serializable {
        private final String[] externalName;
        private final String dataConnection;
        private final String connectorType;
        private final String objectType;
        private final Map<String, String> options;

        public SqlExternalResource(@Nonnull String[] externalName, String dataConnection, @Nonnull String connectorType, String objectType, Map<String, String> options) {
            this.externalName = Objects.requireNonNull(externalName, "externalName cannot be null");
            this.dataConnection = dataConnection;
            this.connectorType = Objects.requireNonNull(connectorType, "connectorType cannot be null");
            this.objectType = objectType;
            this.options = options;
        }

        @Nonnull
        public String[] externalName() {
            return this.externalName;
        }

        @Nullable
        public String dataConnection() {
            return this.dataConnection;
        }

        @Nonnull
        public String connectorType() {
            return this.connectorType;
        }

        @Nullable
        public String objectType() {
            return this.objectType;
        }

        @Nonnull
        public Map<String, String> options() {
            return this.options == null ? Collections.emptyMap() : this.options;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SqlExternalResource that = (SqlExternalResource)o;
            return Arrays.equals(this.externalName, that.externalName) && Objects.equals(this.dataConnection, that.dataConnection) && Objects.equals(this.connectorType, that.connectorType) && Objects.equals(this.objectType, that.objectType) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataConnection, this.connectorType, this.objectType, this.options);
            result = 31 * result + Arrays.hashCode(this.externalName);
            return result;
        }
    }

    public static class VertexWithInputConfig {
        private final Vertex vertex;
        private final Consumer<Edge> configureEdgeFn;

        public VertexWithInputConfig(Vertex vertex) {
            this(vertex, null);
        }

        public VertexWithInputConfig(Vertex vertex, Consumer<Edge> configureEdgeFn) {
            this.vertex = vertex;
            this.configureEdgeFn = configureEdgeFn;
        }

        public Vertex vertex() {
            return this.vertex;
        }

        public Consumer<Edge> configureEdgeFn() {
            return this.configureEdgeFn;
        }
    }

    public static interface DagBuildContext {
        @Nonnull
        public NodeEngine getNodeEngine();

        @Nonnull
        public DAG getDag();

        @Nonnull
        public <T extends Table> T getTable();

        @Nullable
        public Expression<Boolean> convertFilter(@Nullable HazelcastRexNode var1);

        @Nonnull
        public List<Expression<?>> convertProjection(@Nonnull List<HazelcastRexNode> var1);
    }
}

