/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.sql.impl.row.Row;
import java.util.Objects;

class SingleIntRow
implements Row {
    private final int value;

    SingleIntRow(int value) {
        this.value = value;
    }

    public <T> T get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("SingleIntRow has one column");
        }
        return (T)Integer.valueOf(this.value);
    }

    public int getColumnCount() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleIntRow that = (SingleIntRow)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.value + "}";
    }
}

