/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class InfoSchemaConnector
implements SqlConnector {
    public static final InfoSchemaConnector INSTANCE = new InfoSchemaConnector();
    private static final String TYPE_NAME = "InformationSchema";

    private InfoSchemaConnector() {
    }

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return "InfoSchema";
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of InformationSchema mappings");
        }
        InfoSchemaTable table = (InfoSchemaTable)context.getTable();
        List<Object[]> rows = table.rows();
        Expression<Boolean> convertedPredicate = context.convertFilter(predicate);
        List<Expression<?>> convertedProjection = context.convertProjection(projection);
        return context.getDag().newUniqueVertex(table.toString(), ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx & Serializable)() -> new StaticSourceP(convertedPredicate, convertedProjection, rows))));
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return true;
    }

    private static final class StaticSourceP
    extends AbstractProcessor {
        private final Expression<Boolean> predicate;
        private final List<Expression<?>> projection;
        private final List<Object[]> rows;
        private Traverser<JetSqlRow> traverser;

        private StaticSourceP(Expression<Boolean> predicate, List<Expression<?>> projection, List<Object[]> rows) {
            this.predicate = predicate;
            this.projection = projection;
            this.rows = rows;
        }

        protected void init(@Nonnull Processor.Context context) {
            ExpressionEvalContext evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
            List<JetSqlRow> processedRows = ExpressionUtil.evaluate(this.predicate, this.projection, this.rows.stream().map(row -> new JetSqlRow((SerializationService)evalContext.getSerializationService(), row)), evalContext);
            this.traverser = Traversers.traverseIterable(processedRows);
        }

        public boolean isCooperative() {
            return (this.predicate == null || this.predicate.isCooperative()) && this.projection.stream().allMatch(Expression::isCooperative);
        }

        public boolean complete() {
            return this.emitFromTraverser(this.traverser);
        }

        public boolean closeIsCooperative() {
            return true;
        }
    }
}

