/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UDTAttributesTable
extends InfoSchemaTable {
    private static final String NAME = "attributes";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("udt_catalog", QueryDataType.VARCHAR, false), new TableField("udt_schema", QueryDataType.VARCHAR, false), new TableField("udt_name", QueryDataType.VARCHAR, false), new TableField("attribute_name", QueryDataType.VARCHAR, false), new TableField("ordinal_position", QueryDataType.INT, false), new TableField("attribute_default", QueryDataType.VARCHAR, false), new TableField("is_nullable", QueryDataType.VARCHAR, false), new TableField("data_type", QueryDataType.VARCHAR, false), new TableField("character_maximum_length", QueryDataType.INT, false), new TableField("character_octet_length", QueryDataType.VARCHAR, false), new TableField("character_set_catalog", QueryDataType.VARCHAR, false), new TableField("character_set_schema", QueryDataType.VARCHAR, false), new TableField("character_set_name", QueryDataType.VARCHAR, false), new TableField("collation_catalog", QueryDataType.VARCHAR, false), new TableField("collation_schema", QueryDataType.VARCHAR, false), new TableField("collation_name", QueryDataType.VARCHAR, false), new TableField("numeric_precision", QueryDataType.INT, false), new TableField("numeric_precision_radix", QueryDataType.INT, false), new TableField("numeric_scale", QueryDataType.INT, false), new TableField("datetime_precision", QueryDataType.INT, false), new TableField("interval_type", QueryDataType.VARCHAR, false), new TableField("interval_precision", QueryDataType.INT, false), new TableField("attribute_udt_catalog", QueryDataType.VARCHAR, false), new TableField("attribute_udt_schema", QueryDataType.VARCHAR, false), new TableField("attribute_udt_name", QueryDataType.VARCHAR, false), new TableField("scope_catalog", QueryDataType.VARCHAR, false), new TableField("scope_schema", QueryDataType.VARCHAR, false), new TableField("scope_name", QueryDataType.VARCHAR, false), new TableField("maximum_cardinality", QueryDataType.INT, false), new TableField("dtd_identifier", QueryDataType.VARCHAR, false), new TableField("is_derived_reference_attribute", QueryDataType.VARCHAR, false));
    private final String schema;
    private final List<Type> types;

    public UDTAttributesTable(String catalog, String schemaName, String typesSchema, List<Type> types) {
        super(FIELDS, catalog, schemaName, NAME, new ConstantTableStatistics(0L));
        this.schema = typesSchema;
        this.types = types;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Type type : this.types) {
            List<Type.TypeField> fields = type.getFields();
            int fieldsSize = fields.size();
            for (int i = 0; i < fieldsSize; ++i) {
                Type.TypeField field = fields.get(i);
                rows.add(new Object[]{this.catalog(), this.schema, type.getName(), field.getName(), i + 1, null, "YES", this.toSqlDataTypeString(field.getQueryDataType()), field.getQueryDataType().getTypeFamily().equals((Object)QueryDataTypeFamily.VARCHAR) ? Integer.valueOf(Integer.MAX_VALUE) : null, field.getQueryDataType().getTypeFamily().equals((Object)QueryDataTypeFamily.VARCHAR) ? Integer.valueOf(Integer.MAX_VALUE) : null, null, null, null, null, null, null, field.getQueryDataType().getTypeFamily().isNumeric() ? this.getNumericTypePrecision(field.getQueryDataType()) : null, field.getQueryDataType().getTypeFamily().isNumeric() ? Integer.valueOf(2) : null, field.getQueryDataType().getTypeFamily().isNumericInteger() ? Integer.valueOf(0) : null, field.getQueryDataType().getTypeFamily().isTemporal() ? this.getTemporalTypePrecision(field.getQueryDataType()) : null, null, null, field.getQueryDataType().isCustomType() ? this.catalog() : null, field.getQueryDataType().isCustomType() ? this.schema : null, field.getQueryDataType().isCustomType() ? field.getQueryDataType().getObjectTypeName() : null, null, null, null, null, null, null});
            }
        }
        return rows;
    }

    private String toSqlDataTypeString(QueryDataType dataType) {
        if (dataType.isCustomType()) {
            return "USER-DEFINED";
        }
        return HazelcastTypeUtils.toCalciteType(dataType).getName();
    }

    private Integer getTemporalTypePrecision(QueryDataType dataType) {
        switch (dataType.getTypeFamily()) {
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                return 9;
            }
        }
        return 0;
    }

    private Integer getNumericTypePrecision(QueryDataType dataType) {
        switch (dataType.getTypeFamily()) {
            case TINYINT: {
                return 8;
            }
            case SMALLINT: {
                return 16;
            }
            case INTEGER: {
                return 32;
            }
            case BIGINT: {
                return 64;
            }
            case REAL: {
                return 24;
            }
            case DOUBLE: {
                return 53;
            }
        }
        return 0;
    }
}

