/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.H2SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MysqlSqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class SupportedDatabases {
    private static final ILogger LOGGER = Logger.getLogger(SupportedDatabases.class);
    private static final Set<String> SUPPORTED_DATABASE_NAMES = new HashSet<String>();
    private static final Set<String> DETECTED_DATABASE_NAMES = ConcurrentHashMap.newKeySet();

    private SupportedDatabases() {
    }

    static void logOnceIfDatabaseNotSupported(DatabaseMetaData databaseMetaData) throws SQLException {
        String uppercaseProductName = SupportedDatabases.getProductName(databaseMetaData);
        boolean newDatabaseName = SupportedDatabases.isNewDatabase(uppercaseProductName);
        if (newDatabaseName) {
            LOGGER.warning("Database " + uppercaseProductName + " is not supported, it may or may not work. If you come across any issues please report them on Github.");
        }
    }

    private static String getProductName(DatabaseMetaData databaseMetaData) throws SQLException {
        String productName = databaseMetaData.getDatabaseProductName();
        return StringUtil.upperCaseInternal((String)productName);
    }

    static boolean isNewDatabase(String uppercaseProductName) {
        if (SUPPORTED_DATABASE_NAMES.contains(uppercaseProductName)) {
            return false;
        }
        return DETECTED_DATABASE_NAMES.add(uppercaseProductName);
    }

    static boolean isDialectSupported(SqlDialect dialect) {
        return dialect instanceof MysqlSqlDialect || dialect instanceof PostgresqlSqlDialect || dialect instanceof H2SqlDialect;
    }

    static {
        SUPPORTED_DATABASE_NAMES.add("MYSQL");
        SUPPORTED_DATABASE_NAMES.add("POSTGRESQL");
        SUPPORTED_DATABASE_NAMES.add("H2");
    }
}

