/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import java.util.Set;

public class SupportsRexVisitor
extends RexVisitorImpl<Boolean> {
    private static final Set<String> OTHER_SUPPORTED = ImmutableSet.of("||", "NOT LIKE", "LENGTH", "LOWER", "UPPER");

    protected SupportsRexVisitor() {
        super(true);
    }

    @Override
    public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
        return true;
    }

    @Override
    public Boolean visitInputRef(RexInputRef inputRef) {
        return true;
    }

    @Override
    public Boolean visitLiteral(RexLiteral literal) {
        return true;
    }

    @Override
    public Boolean visitCall(RexCall call) {
        SqlKind kind;
        SqlOperator operator = call.getOperator();
        return SupportsRexVisitor.operatorSupported(operator, kind = operator.getKind()) && this.operandsSupported(call);
    }

    private static boolean operatorSupported(SqlOperator operator, SqlKind kind) {
        switch (kind) {
            case EQUALS: 
            case AND: 
            case OR: 
            case NOT: 
            case NOT_EQUALS: 
            case SEARCH: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LIKE: 
            case IS_NULL: 
            case IS_NOT_NULL: 
            case NULLIF: 
            case IS_NOT_TRUE: 
            case IS_NOT_FALSE: 
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case DIVIDE: 
            case COALESCE: 
            case CAST: {
                return true;
            }
            case OTHER: 
            case OTHER_FUNCTION: {
                return OTHER_SUPPORTED.contains(operator.getName());
            }
        }
        return false;
    }

    private boolean operandsSupported(RexCall call) {
        for (RexNode operand : call.operands) {
            Boolean supports = operand.accept(this);
            if (supports != null && supports.booleanValue()) continue;
            return false;
        }
        return true;
    }
}

