/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TypesUtils;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KvMetadataResolvers {
    private static final Pattern EXT_NAME_PATTERN = Pattern.compile("((" + QueryPath.KEY + "|" + QueryPath.VALUE + ")\\.)?[^.]+");
    private static final Set<TypeKind> NESTED_FIELDS_SUPPORTED_FORMATS = ImmutableSet.of(TypeKind.JAVA, TypeKind.PORTABLE, TypeKind.COMPACT);
    private final Map<String, KvMetadataResolver> keyResolvers;
    private final Map<String, KvMetadataResolver> valueResolvers;

    public KvMetadataResolvers(KvMetadataResolver ... resolvers) {
        this(resolvers, resolvers);
    }

    public KvMetadataResolvers(KvMetadataResolver[] keyResolvers, KvMetadataResolver[] valueResolvers) {
        this.keyResolvers = this.resolversMap(keyResolvers);
        this.valueResolvers = this.resolversMap(valueResolvers);
    }

    private Map<String, KvMetadataResolver> resolversMap(KvMetadataResolver[] resolvers) {
        return Arrays.stream(resolvers).flatMap(resolver -> resolver.supportedFormats().map(format -> Util.entry((Object)format, (Object)resolver))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, String> options, NodeEngine nodeEngine) {
        Map fields;
        TypeKind valueKind;
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        RelationsStorage relationsStorage = ((SqlServiceImpl)nodeEngine.getSqlService()).getOptimizer().relationsStorage();
        for (MappingField field2 : userFields) {
            String name = field2.name();
            String externalName = field2.externalName();
            if (externalName == null) {
                externalName = name.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) ? name : QueryPath.VALUE_PREFIX + name;
                field2.setExternalName(name);
            }
            if (name.equals(QueryPath.KEY) && !externalName.equals(QueryPath.KEY) || name.equals(QueryPath.VALUE) && !externalName.equals(QueryPath.VALUE)) {
                throw QueryException.error((String)("Cannot rename field: '" + name + '\''));
            }
            if (EXT_NAME_PATTERN.matcher(externalName).matches()) continue;
            throw QueryException.error((String)("Invalid external name: " + externalName));
        }
        Stream<MappingField> keyFields = this.findMetadataResolver(options, true).resolveAndValidateFields(true, userFields, options, ss).filter(field -> !field.name().equals(QueryPath.KEY) || field.externalName().equals(QueryPath.KEY));
        Stream<MappingField> valueFields = this.findMetadataResolver(options, false).resolveAndValidateFields(false, userFields, options, ss).filter(field -> !field.name().equals(QueryPath.VALUE) || field.externalName().equals(QueryPath.VALUE));
        TypeKind keyKind = TypesUtils.formatToTypeKind(this.getFormat(options, true));
        if (NESTED_FIELDS_SUPPORTED_FORMATS.contains((Object)keyKind)) {
            keyFields = keyFields.peek(mappingField -> TypesUtils.enrichMappingFieldType(keyKind, mappingField, relationsStorage));
        }
        if (NESTED_FIELDS_SUPPORTED_FORMATS.contains((Object)(valueKind = TypesUtils.formatToTypeKind(this.getFormat(options, false))))) {
            valueFields = valueFields.peek(mappingField -> TypesUtils.enrichMappingFieldType(valueKind, mappingField, relationsStorage));
        }
        if ((fields = (Map)Stream.concat(keyFields, valueFields).collect(LinkedHashMap::new, (map, field) -> map.putIfAbsent(field.name(), field), Map::putAll)).isEmpty()) {
            throw QueryException.error((String)"The resolved field list is empty");
        }
        return new ArrayList<MappingField>(fields.values());
    }

    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        KvMetadataResolver resolver = this.findMetadataResolver(options, isKey);
        return Objects.requireNonNull(resolver.resolveMetadata(isKey, resolvedFields, options, serializationService));
    }

    private KvMetadataResolver findMetadataResolver(Map<String, String> options, boolean isKey) {
        String option;
        String format;
        KvMetadataResolver resolver = (isKey ? this.keyResolvers : this.valueResolvers).get(format = options.get(option = isKey ? "keyFormat" : "valueFormat"));
        if (resolver == null) {
            if (format == null) {
                throw QueryException.error((String)("Missing '" + option + "' option"));
            }
            throw QueryException.error((String)("Unsupported serialization format: " + format));
        }
        return resolver;
    }

    private String getFormat(Map<String, String> options, boolean isKey) {
        String option = isKey ? "keyFormat" : "valueFormat";
        return options.get(option);
    }
}

