/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexType;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataJavaResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProcessors;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.Joiner;
import com.hazelcast.jet.sql.impl.connector.map.MapIndexScanP;
import com.hazelcast.jet.sql.impl.connector.map.MetadataCompactResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataJsonResolver;
import com.hazelcast.jet.sql.impl.connector.map.MetadataPortableResolver;
import com.hazelcast.jet.sql.impl.connector.map.RowProjectorProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdateProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdatingEntryProcessor;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.exec.scan.MapIndexScanMetadata;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IMapSqlConnector
implements SqlConnector {
    public static final IMapSqlConnector INSTANCE = new IMapSqlConnector();
    public static final String TYPE_NAME = "IMap";
    public static final String OBJECT_TYPE_IMAP = "IMap";
    public static final List<String> PRIMARY_KEY_LIST = Collections.singletonList(QueryPath.KEY);
    private static final KvMetadataResolvers METADATA_RESOLVERS_WITH_COMPACT = new KvMetadataResolvers(KvMetadataJavaResolver.INSTANCE, MetadataPortableResolver.INSTANCE, MetadataCompactResolver.INSTANCE, MetadataJsonResolver.INSTANCE);

    @Override
    public String typeName() {
        return "IMap";
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return "IMap";
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        IMapSqlConnector.checkImapName(externalResource.externalName());
        return METADATA_RESOLVERS_WITH_COMPACT.resolveAndValidateFields(userFields, externalResource.options(), nodeEngine);
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        IMapSqlConnector.checkImapName(externalResource.externalName());
        InternalSerializationService ss = (InternalSerializationService)nodeEngine.getSerializationService();
        KvMetadata keyMetadata = METADATA_RESOLVERS_WITH_COMPACT.resolveMetadata(true, resolvedFields, externalResource.options(), ss);
        KvMetadata valueMetadata = METADATA_RESOLVERS_WITH_COMPACT.resolveMetadata(false, resolvedFields, externalResource.options(), ss);
        List<TableField> fields = Stream.concat(keyMetadata.getFields().stream(), valueMetadata.getFields().stream()).collect(Collectors.toList());
        MapService service = (MapService)nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        String mapName = externalResource.externalName()[0];
        MapContainer container = context.getExistingMapContainer(mapName);
        long estimatedRowCount = MapTableUtils.estimatePartitionedMapRowCount(nodeEngine, context, mapName);
        boolean hd = container != null && container.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
        List<MapTableIndex> indexes = container != null ? MapTableUtils.getPartitionedMapIndexes(container, fields) : Collections.emptyList();
        return new PartitionedMapTable(schemaName, mappingName, mapName, fields, new ConstantTableStatistics(estimatedRowCount), keyMetadata.getQueryTargetDescriptor(), valueMetadata.getQueryTargetDescriptor(), keyMetadata.getUpsertTargetDescriptor(), valueMetadata.getUpsertTargetDescriptor(), indexes, hd);
    }

    private static void checkImapName(@Nonnull String[] externalName) {
        if (externalName.length > 1) {
            throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalName) + ", external name for IMap is allowed to have only a single component referencing the map name"));
        }
        String mapName = externalName[0];
        if (mapName.startsWith("__jet.") || mapName.equals("__sql.catalog")) {
            throw QueryException.error((String)"Mapping of internal IMaps is not allowed");
        }
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode filter, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of IMap mappings");
        }
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        Vertex vStart = context.getDag().newUniqueVertex(IMapSqlConnector.toString(table), SourceProcessors.readMapP((String)table.getMapName()));
        Vertex vEnd = context.getDag().newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", RowProjectorProcessorSupplier.rowProjector(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), context.convertFilter(filter), context.convertProjection(projection)));
        context.getDag().edge(Edge.from((Vertex)vStart).to(vEnd).isolated());
        return vEnd;
    }

    @Nonnull
    public Vertex indexScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nonnull Address localMemberAddress, @Nonnull MapTableIndex tableIndex, @Nullable HazelcastRexNode remainingFilter, @Nonnull List<HazelcastRexNode> projection, @Nullable IndexFilter indexFilter, @Nullable ComparatorEx<JetSqlRow> comparator, boolean descending) {
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        MapIndexScanMetadata indexScanMetadata = new MapIndexScanMetadata(table.getMapName(), tableIndex.getName(), table.getKeyDescriptor(), table.getValueDescriptor(), Arrays.asList(table.paths()), Arrays.asList(table.types()), indexFilter, context.convertProjection(projection), context.convertFilter(remainingFilter), comparator, descending);
        Vertex scanner = context.getDag().newUniqueVertex("Index(" + IMapSqlConnector.toString(table) + ")", MapIndexScanP.readMapIndexSupplier(indexScanMetadata));
        scanner.localParallelism(1);
        if (tableIndex.getType() == IndexType.SORTED) {
            Vertex sorter = context.getDag().newUniqueVertex("SortCombine", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)Processors.mapP((FunctionEx)FunctionEx.identity())), (Address)localMemberAddress));
            assert (comparator != null);
            context.getDag().edge(Edge.between((Vertex)scanner, (Vertex)sorter).ordered(comparator).distributeTo(localMemberAddress).allToOne((Object)""));
            return sorter;
        }
        return scanner;
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig nestedLoopReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projections, @Nonnull JetJoinInfo joinInfo) {
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        KvRowProjector.Supplier rightRowProjectorSupplier = KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), context.convertFilter(predicate), context.convertProjection(projections));
        return Joiner.join(context.getDag(), table.getMapName(), IMapSqlConnector.toString(table), joinInfo, rightRowProjectorSupplier);
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        Vertex vertex = context.getDag().newUniqueVertex(IMapSqlConnector.toString(table), (ProcessorSupplier)new InsertProcessorSupplier(table.getMapName(), KvProjector.supplier(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true))).localParallelism(1);
        return new SqlConnector.VertexWithInputConfig(vertex, edge -> edge.distributed().allToOne((Object)UuidUtil.newUnsecureUuidString()));
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        Vertex vStart = context.getDag().newUniqueVertex("Project(" + IMapSqlConnector.toString(table) + ")", KvProcessors.entryProjector(table.paths(), table.types(), (UpsertTargetDescriptor)table.getKeyJetMetadata(), (UpsertTargetDescriptor)table.getValueJetMetadata(), true));
        Vertex vEnd = context.getDag().newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.writeMapP((String)table.getMapName()));
        context.getDag().edge(Edge.between((Vertex)vStart, (Vertex)vEnd));
        return vStart;
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nonnull List<String> fieldNames, @Nonnull List<HazelcastRexNode> expressions, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null);
        assert (hasInput);
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        return context.getDag().newUniqueVertex("Update(" + IMapSqlConnector.toString(table) + ")", (ProcessorSupplier)new UpdateProcessorSupplier(table.getMapName(), UpdatingEntryProcessor.supplier(table, fieldNames, context.convertProjection(expressions))));
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null);
        assert (hasInput);
        PartitionedMapTable table = (PartitionedMapTable)context.getTable();
        return context.getDag().newUniqueVertex(IMapSqlConnector.toString(table), SinkProcessors.updateMapP((String)table.getMapName(), (FunctionEx & Serializable)row -> {
            assert (row.getFieldCount() == 1);
            return row.get(0);
        }, (BiFunctionEx & Serializable)(v, t2) -> null));
    }

    @Override
    public boolean dmlSupportsPredicates() {
        return false;
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return true;
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        return PRIMARY_KEY_LIST;
    }

    private static String toString(PartitionedMapTable table) {
        return "IMap[" + table.getSchemaName() + "." + table.getSqlName() + "]";
    }
}

