/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.UpdateMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DeleteProcessorSupplier
implements ProcessorSupplier {
    private final String connectionString;
    private final String databaseName;
    private final String collectionName;
    private final Serializable predicate;
    private final String[] externalNames;
    private final boolean hasInput;
    private transient SupplierEx<MongoClient> clientSupplier;
    private final String dataConnectionName;
    private final String idField;
    private ExpressionEvalContext evalContext;

    DeleteProcessorSupplier(MongoTable table, Serializable predicate, boolean hasInput) {
        this.connectionString = table.connectionString;
        this.databaseName = table.databaseName;
        this.dataConnectionName = table.dataConnectionName;
        this.collectionName = table.collectionName;
        this.externalNames = table.externalNames();
        this.idField = table.primaryKeyExternalName();
        this.predicate = predicate;
        this.hasInput = hasInput;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create((String)this.connectionString);
        }
        this.evalContext = ExpressionEvalContext.from(context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        for (int i = 0; i < count; ++i) {
            UpdateMongoP processor;
            if (this.hasInput) {
                processor = new WriteMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Object.class).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToDoc).setWriteModelFn(this::delete));
            } else {
                Document predicateWithReplacements = this.predicate == null ? MongoUtilities.UPDATE_ALL_PREDICATE : DynamicallyReplacedPlaceholder.replacePlaceholdersInPredicate(this.predicate, this.externalNames, this.evalContext);
                processor = new UpdateMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class), (SupplierEx & Serializable)() -> new DeleteManyModel((Bson)predicateWithReplacements));
            }
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private WriteModel<Object> delete(Object pkValue) {
        return new DeleteManyModel(Filters.eq((String)this.idField, (Object)pkValue));
    }

    private Object rowToDoc(JetSqlRow row) {
        assert (row.getFieldCount() == 1);
        return row.getValues()[0];
    }
}

