/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class DynamicParameter
implements DynamicallyReplacedPlaceholder {
    private static final Pattern PATTERN = Pattern.compile("<!DynamicParameter\\((\\d+)\\)!>");
    private final int index;

    public DynamicParameter(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    @Nonnull
    public String asString() {
        return "<!DynamicParameter(" + this.index + ")!>";
    }

    public static DynamicParameter matches(Object o) {
        Matcher matcher;
        if (o instanceof String && (matcher = PATTERN.matcher((String)o)).matches()) {
            return new DynamicParameter(Integer.parseInt(matcher.group(1)));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicParameter)) {
            return false;
        }
        DynamicParameter that = (DynamicParameter)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return "DynamicParameter(" + this.index + ')';
    }
}

