/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicParameter;
import com.hazelcast.jet.sql.impl.connector.mongodb.InputRef;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;

final class PlaceholderReplacer {
    private PlaceholderReplacer() {
    }

    static Document replacePlaceholders(Document doc, ExpressionEvalContext evalContext, JetSqlRow inputRow, String[] externalNames, boolean forRow) {
        Object[] values = inputRow.getValues();
        return PlaceholderReplacer.replacePlaceholders(doc, evalContext, values, externalNames, forRow);
    }

    static Document replacePlaceholders(Document doc, ExpressionEvalContext evalContext, Object[] inputRow, String[] externalNames, boolean readValueFromInput) {
        Document result = new Document();
        for (Map.Entry entry : doc.entrySet()) {
            String entryKey = (String)entry.getKey();
            Object entryValue = entry.getValue();
            entryKey = (String)PlaceholderReplacer.replace(entryKey, evalContext, inputRow, externalNames, true, readValueFromInput);
            if (entryValue instanceof String) {
                entryValue = PlaceholderReplacer.replace((String)entryValue, evalContext, inputRow, externalNames, false, readValueFromInput);
            }
            if (entryValue instanceof List) {
                ArrayList newValues = new ArrayList();
                Iterator iterator = ((List)entryValue).iterator();
                while (iterator.hasNext()) {
                    Object val;
                    Object v = val = iterator.next();
                    if (val instanceof Document) {
                        v = PlaceholderReplacer.replacePlaceholders((Document)val, evalContext, inputRow, externalNames, readValueFromInput);
                    } else if (val instanceof String) {
                        v = PlaceholderReplacer.replace((String)val, evalContext, inputRow, externalNames, false, readValueFromInput);
                    }
                    newValues.add(v);
                }
                entryValue = newValues;
            } else if (entryValue instanceof Document) {
                entryValue = PlaceholderReplacer.replacePlaceholders((Document)entryValue, evalContext, inputRow, externalNames, readValueFromInput);
            }
            result.append(entryKey, entryValue);
        }
        assert (result.size() == doc.size()) : "result size should match input size";
        return result;
    }

    static Object replace(String entryKey, ExpressionEvalContext evalContext, Object[] inputRow, String[] externalNames, boolean key, boolean forRow) {
        DynamicParameter dynamicParameter = DynamicParameter.matches(entryKey);
        if (dynamicParameter != null) {
            Object arg = evalContext.getArgument(dynamicParameter.getIndex());
            assert (!key || arg instanceof String) : "keys must be Strings";
            return arg;
        }
        InputRef ref = InputRef.match(entryKey);
        if (ref != null) {
            if (key) {
                return externalNames[ref.getInputIndex()];
            }
            if (!forRow) {
                return "$" + externalNames[ref.getInputIndex()];
            }
            return inputRow[ref.getInputIndex()];
        }
        return entryKey;
    }
}

