/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CsvQueryTarget
implements QueryTarget {
    private final List<String> fieldList;
    private String[] entry;

    public CsvQueryTarget(List<String> fieldList) {
        this.fieldList = fieldList;
        assert (new HashSet<String>(fieldList).size() == fieldList.size()) : "duplicates in the fieldList";
    }

    @Override
    public void setTarget(Object target, Data targetData) {
        assert (targetData == null);
        this.entry = (String[])target;
        assert (this.entry.length == this.fieldList.size());
    }

    @Override
    public QueryExtractor createExtractor(String path, QueryDataType type) {
        return path == null ? this.createExtractor() : this.createFieldExtractor(path, type);
    }

    private QueryExtractor createExtractor() {
        return () -> this.entry;
    }

    private QueryExtractor createFieldExtractor(String path, QueryDataType type) {
        int fieldIndex = this.fieldList.indexOf(path);
        return () -> type.convert(this.entry[fieldIndex]);
    }
}

