/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetUtils;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class PortableUpsertTarget
implements UpsertTarget {
    private static final Object NOT_SET = new Object();
    private final ClassDefinition classDefinition;
    private final Object[] values;
    private final Map<Integer, QueryDataType> dataTypeMap;

    PortableUpsertTarget(@Nonnull ClassDefinition classDef) {
        this.classDefinition = classDef;
        this.values = new Object[classDef.getFieldCount()];
        this.dataTypeMap = new HashMap<Integer, QueryDataType>();
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        int fieldIndex;
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        int n = fieldIndex = this.classDefinition.hasField(path) ? this.classDefinition.getField(path).getIndex() : -1;
        if (type.isCustomType() && type.getObjectTypeKind() == QueryDataType.OBJECT_TYPE_KIND_PORTABLE) {
            this.dataTypeMap.put(fieldIndex, type);
        }
        return value -> {
            if (fieldIndex == -1 && value != null) {
                throw QueryException.error((String)("Field \"" + path + "\" doesn't exist in Portable Class Definition"));
            }
            if (fieldIndex > -1) {
                this.values[fieldIndex] = value;
            }
        };
    }

    @Override
    public void init() {
        Arrays.fill(this.values, NOT_SET);
    }

    @Override
    public Object conclude() {
        GenericRecord record = this.toRecord(this.classDefinition, this.values);
        Arrays.fill(this.values, NOT_SET);
        return record;
    }

    private GenericRecord toRecord(ClassDefinition classDefinition, Object[] values) {
        PortableGenericRecordBuilder portable = new PortableGenericRecordBuilder(classDefinition);
        for (int i = 0; i < classDefinition.getFieldCount(); ++i) {
            FieldDefinition fieldDefinition = classDefinition.getField(i);
            String name = fieldDefinition.getName();
            FieldType type = fieldDefinition.getType();
            Object value = values[i];
            try {
                switch (type) {
                    case BOOLEAN: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setBoolean(name, value != NOT_SET && (Boolean)value != false);
                        break;
                    }
                    case BYTE: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setInt8(name, value == NOT_SET ? (byte)0 : (Byte)value);
                        break;
                    }
                    case SHORT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setInt16(name, value == NOT_SET ? (short)0 : (Short)value);
                        break;
                    }
                    case CHAR: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setChar(name, value == NOT_SET ? (char)'\u0000' : ((Character)value).charValue());
                        break;
                    }
                    case INT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setInt32(name, value == NOT_SET ? 0 : (Integer)value);
                        break;
                    }
                    case LONG: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setInt64(name, value == NOT_SET ? 0L : (Long)value);
                        break;
                    }
                    case FLOAT: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setFloat32(name, value == NOT_SET ? 0.0f : ((Float)value).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        PortableUpsertTarget.ensureNotNull(value);
                        portable.setFloat64(name, value == NOT_SET ? 0.0 : (Double)value);
                        break;
                    }
                    case DECIMAL: {
                        portable.setDecimal(name, value == NOT_SET ? null : (BigDecimal)value);
                        break;
                    }
                    case UTF: {
                        portable.setString(name, value == NOT_SET ? null : (String)QueryDataType.VARCHAR.convert(value));
                        break;
                    }
                    case TIME: {
                        portable.setTime(name, value == NOT_SET ? null : (LocalTime)value);
                        break;
                    }
                    case DATE: {
                        portable.setDate(name, value == NOT_SET ? null : (LocalDate)value);
                        break;
                    }
                    case TIMESTAMP: {
                        portable.setTimestamp(name, value == NOT_SET ? null : (LocalDateTime)value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        portable.setTimestampWithTimezone(name, value == NOT_SET ? null : (OffsetDateTime)value);
                        break;
                    }
                    case PORTABLE: {
                        if (value instanceof RowValue) {
                            portable.setGenericRecord(name, UpsertTargetUtils.convertRowToPortableType((RowValue)value, this.dataTypeMap.get(i)));
                            break;
                        }
                        portable.setGenericRecord(name, value == NOT_SET ? null : (GenericRecord)value);
                        break;
                    }
                    case BOOLEAN_ARRAY: {
                        portable.setArrayOfBoolean(name, value == NOT_SET ? null : (boolean[])value);
                        break;
                    }
                    case BYTE_ARRAY: {
                        portable.setArrayOfInt8(name, value == NOT_SET ? null : (byte[])value);
                        break;
                    }
                    case SHORT_ARRAY: {
                        portable.setArrayOfInt16(name, value == NOT_SET ? null : (short[])value);
                        break;
                    }
                    case CHAR_ARRAY: {
                        portable.setArrayOfChar(name, value == NOT_SET ? null : (char[])value);
                        break;
                    }
                    case INT_ARRAY: {
                        portable.setArrayOfInt32(name, value == NOT_SET ? null : (int[])value);
                        break;
                    }
                    case LONG_ARRAY: {
                        portable.setArrayOfInt64(name, value == NOT_SET ? null : (long[])value);
                        break;
                    }
                    case FLOAT_ARRAY: {
                        portable.setArrayOfFloat32(name, value == NOT_SET ? null : (float[])value);
                        break;
                    }
                    case DOUBLE_ARRAY: {
                        portable.setArrayOfFloat64(name, value == NOT_SET ? null : (double[])value);
                        break;
                    }
                    case DECIMAL_ARRAY: {
                        portable.setArrayOfDecimal(name, value == NOT_SET ? null : (BigDecimal[])value);
                        break;
                    }
                    case UTF_ARRAY: {
                        portable.setArrayOfString(name, value == NOT_SET ? null : (String[])value);
                        break;
                    }
                    case TIME_ARRAY: {
                        portable.setArrayOfTime(name, value == NOT_SET ? null : (LocalTime[])value);
                        break;
                    }
                    case DATE_ARRAY: {
                        portable.setArrayOfDate(name, value == NOT_SET ? null : (LocalDate[])value);
                        break;
                    }
                    case TIMESTAMP_ARRAY: {
                        portable.setArrayOfTimestamp(name, value == NOT_SET ? null : (LocalDateTime[])value);
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE_ARRAY: {
                        portable.setArrayOfTimestampWithTimezone(name, value == NOT_SET ? null : (OffsetDateTime[])value);
                        break;
                    }
                    case PORTABLE_ARRAY: {
                        portable.setArrayOfGenericRecord(name, value == NOT_SET ? null : (GenericRecord[])value);
                        break;
                    }
                    default: {
                        throw QueryException.error((String)("Unsupported type: " + type));
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw QueryException.error((String)("Cannot set value " + (value == null ? "null" : "of type " + value.getClass().getName()) + " to field \"" + name + "\" of type " + type + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return portable.build();
    }

    private static void ensureNotNull(Object value) {
        if (value == null) {
            throw QueryException.error((String)"Cannot set NULL to a primitive field");
        }
    }
}

