/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeleteLogicalRel
extends AbstractRelNode
implements LogicalRel {
    private final RelOptTable table;
    private final Prepare.CatalogReader catalogReader;
    private final RelNode input;
    private final boolean flattened;
    private final RexNode predicate;

    protected DeleteLogicalRel(@Nonnull RelOptCluster cluster, @Nonnull RelTraitSet traitSet, @Nonnull RelOptTable table, @Nonnull Prepare.CatalogReader catalogReader, @Nullable RelNode input, boolean flattened, @Nullable RexNode predicate) {
        super(cluster, traitSet);
        this.table = table;
        this.catalogReader = catalogReader;
        this.input = input;
        this.flattened = flattened;
        this.predicate = predicate;
    }

    @Override
    @Nonnull
    public RelOptTable getTable() {
        return this.table;
    }

    @Nonnull
    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Nullable
    public RelNode getInput() {
        return this.input;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.input != null ? Collections.singletonList(this.input) : Collections.emptyList();
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    @Nullable
    public RexNode getPredicate() {
        return this.predicate;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.DELETE, this.getCluster().getTypeFactory());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DeleteLogicalRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), DeleteLogicalRel.sole(inputs), this.isFlattened(), this.predicate);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        RelWriter w = super.explainTerms(pw);
        if (this.input != null) {
            w.input("input", this.getInput());
        }
        return w.item("table", this.table.getQualifiedName()).item("flattened", this.flattened).itemIf("predicate", this.predicate, this.predicate != null);
    }
}

