/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.cost.CostUtils;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.List;
import javax.annotation.Nullable;

public class FullScanLogicalRel
extends FullScan
implements LogicalRel {
    public FullScanLogicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, @Nullable Expression<?> lagExpression, int watermarkedColumnIndex) {
        super(cluster, traitSet, table, lagExpression, watermarkedColumnIndex);
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FullScanLogicalRel(this.getCluster(), traitSet, this.getTable(), this.lagExpression(), this.watermarkedColumnIndex());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double totalRowCount;
        HazelcastTable table = this.getTable().unwrap(HazelcastTable.class);
        double d = totalRowCount = table.getStatistic().getRowCount() != null ? table.getTotalRowCount() : this.getTable().getRowCount();
        if (totalRowCount == 0.0) {
            totalRowCount = 1.0;
        }
        double scanCpu = totalRowCount * 1.0;
        double projectCpu = CostUtils.getProjectCpu(totalRowCount, table.getProjects().size());
        return planner.getCostFactory().makeCost(totalRowCount, scanCpu + projectCpu, 0.0);
    }
}

