/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;

public class UpdateByKeyMapLogicalRel
extends AbstractRelNode
implements LogicalRel {
    private final RelOptTable table;
    private final RexNode keyCondition;
    private final List<String> updatedColumns;
    private final List<RexNode> sourceExpressions;

    UpdateByKeyMapLogicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, RexNode keyCondition, List<String> updatedColumns, List<RexNode> sourceExpressions) {
        super(cluster, traitSet);
        assert (table.unwrap(HazelcastTable.class).getTarget() instanceof PartitionedMapTable);
        this.table = table;
        this.keyCondition = keyCondition;
        this.updatedColumns = updatedColumns;
        this.sourceExpressions = sourceExpressions;
    }

    public RelOptTable table() {
        return this.table;
    }

    public RexNode keyCondition() {
        return this.keyCondition;
    }

    public List<String> updatedColumns() {
        return this.updatedColumns;
    }

    public List<RexNode> sourceExpressions() {
        return this.sourceExpressions;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.UPDATE, this.getCluster().getTypeFactory());
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("table", this.table.getQualifiedName()).item("keyCondition", this.keyCondition).item("updatedColumns", this.updatedColumns).item("sourceExpressions", this.sourceExpressions);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new UpdateByKeyMapLogicalRel(this.getCluster(), traitSet, this.table, this.keyCondition, this.updatedColumns, this.sourceExpressions);
    }
}

