/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.SingleRel;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.sql.impl.expression.Expression;
import java.util.List;

public class WatermarkLogicalRel
extends SingleRel
implements LogicalRel {
    private final Expression<?> lagExpression;
    private final int watermarkedColumnIndex;

    WatermarkLogicalRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, Expression<?> lagExpression, int watermarkedColumnIndex) {
        super(cluster, traits, input);
        this.lagExpression = lagExpression;
        this.watermarkedColumnIndex = watermarkedColumnIndex;
    }

    public Expression<?> lagExpression() {
        return this.lagExpression;
    }

    public int watermarkedColumnIndex() {
        return this.watermarkedColumnIndex;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("watermarkedColumnIndex", this.watermarkedColumnIndex);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeHugeCost();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new WatermarkLogicalRel(this.getCluster(), traitSet, WatermarkLogicalRel.sole(inputs), this.lagExpression, this.watermarkedColumnIndex);
    }
}

