/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;
import java.util.stream.Collectors;

public class SelectByKeyMapPhysicalRel
extends AbstractRelNode
implements PhysicalRel {
    private final RelOptTable table;
    private final RexNode keyCondition;
    private final List<? extends RexNode> projections;

    SelectByKeyMapPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelDataType rowType, RelOptTable table, RexNode keyCondition, List<? extends RexNode> projections) {
        super(cluster, traitSet);
        this.rowType = rowType;
        assert (table.unwrap(HazelcastTable.class).getTarget() instanceof PartitionedMapTable);
        this.table = table;
        this.keyCondition = keyCondition;
        this.projections = projections;
    }

    public String mapName() {
        return this.table().getMapName();
    }

    public PlanObjectKey objectKey() {
        return this.table().getObjectKey();
    }

    public Expression<?> keyCondition(QueryParameterMetadata parameterMetadata) {
        RexToExpressionVisitor visitor = new RexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, parameterMetadata);
        return (Expression)this.keyCondition.accept(visitor);
    }

    public KvRowProjector.Supplier rowProjectorSupplier(QueryParameterMetadata parameterMetadata) {
        PartitionedMapTable table = this.table();
        return KvRowProjector.supplier(table.paths(), table.types(), table.getKeyDescriptor(), table.getValueDescriptor(), null, this.projection(parameterMetadata));
    }

    private PartitionedMapTable table() {
        return (PartitionedMapTable)this.table.unwrap(HazelcastTable.class).getTarget();
    }

    private List<Expression<?>> projection(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema inputSchema = OptUtils.schema(this.table);
        return this.project(inputSchema, this.projections, parameterMetadata);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        List fieldTypes = Util.toList(this.projection(parameterMetadata), Expression::getType);
        return new PlanNodeSchema(fieldTypes);
    }

    @Override
    public <V> V accept(CreateDagVisitor<V> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("table", this.table.getQualifiedName()).item("keyCondition", this.keyCondition).item("projections", Ord.zip(this.rowType.getFieldList()).stream().map(field -> {
            String fieldName = ((RelDataTypeField)field.e).getName() == null ? "field#" + field.i : ((RelDataTypeField)field.e).getName();
            return fieldName + "=[" + this.projections.get(field.i) + "]";
        }).collect(Collectors.joining(", ")));
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SelectByKeyMapPhysicalRel(this.getCluster(), traitSet, this.rowType, this.table, this.keyCondition, this.projections);
    }
}

