/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.HazelcastSqlToRelConverter;
import com.hazelcast.jet.sql.impl.opt.ExtractUpdateExpressionsRule;
import com.hazelcast.jet.sql.impl.opt.logical.CalcMergeRule;
import com.hazelcast.jet.sql.impl.parse.QueryConvertResult;
import com.hazelcast.shaded.org.apache.calcite.plan.Contexts;
import com.hazelcast.shaded.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCostImpl;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelRoot;
import com.hazelcast.shaded.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalFilter;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.CoreRules;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.PruneEmptyRules;
import com.hazelcast.shaded.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql2rel.RelDecorrelator;
import com.hazelcast.shaded.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.shaded.org.apache.calcite.sql2rel.StandardConvertletTable;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import javax.annotation.Nullable;

public class QueryConverter {
    public static final SqlToRelConverter.Config CONFIG = SqlToRelConverter.config().withExpand(false).withInSubQueryThreshold(10000).withTrimUnusedFields(true);
    private static final boolean EXPAND = false;
    private static final boolean TRIM_UNUSED_FIELDS = true;
    private static final int HAZELCAST_IN_ELEMENTS_THRESHOLD = 10000;
    private final SqlValidator validator;
    private final Prepare.CatalogReader catalogReader;
    private final RelOptCluster cluster;

    public QueryConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, HazelcastRelOptCluster cluster) {
        this.validator = validator;
        this.catalogReader = catalogReader;
        this.cluster = cluster;
    }

    public QueryConvertResult convert(SqlNode node) {
        HazelcastSqlToRelConverter converter = this.createSqlToRelConverter();
        RelRoot root = converter.convertQuery(node, false, true);
        RelNode relNoSubqueries = QueryConverter.performUnconditionalRewrites(root.project());
        RelNode result = converter.decorrelate(node, relNoSubqueries);
        if (!QueryConverter.hasNestedExists(root.rel)) {
            result = converter.trimUnusedFields(true, result);
        }
        result = QueryConverter.transformProjectAndFilterIntoCalc(result);
        return new QueryConvertResult(result, Pair.right(root.fields));
    }

    public RelNode convertView(SqlNode node) {
        HazelcastSqlToRelConverter sqlToRelConverter = this.createSqlToRelConverter();
        RelRoot root = sqlToRelConverter.convertQuery(node, true, true);
        RelRoot root2 = root.withRel(sqlToRelConverter.flattenTypes(root.rel, true));
        RelBuilder relBuilder = CONFIG.getRelBuilderFactory().create(this.cluster, null);
        RelRoot root3 = root2.withRel(RelDecorrelator.decorrelateQuery(root.rel, relBuilder));
        return root3.project();
    }

    private HazelcastSqlToRelConverter createSqlToRelConverter() {
        return new HazelcastSqlToRelConverter(this.validator, this.catalogReader, this.cluster, StandardConvertletTable.INSTANCE, CONFIG);
    }

    private static RelNode performUnconditionalRewrites(RelNode rel) {
        HepProgramBuilder hepProgramBuilder = new HepProgramBuilder();
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.PROJECT_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.JOIN_SUB_QUERY_TO_CORRELATE);
        hepProgramBuilder.addRuleInstance(CoreRules.UNION_MERGE);
        hepProgramBuilder.addRuleInstance(CoreRules.UNION_TO_DISTINCT);
        hepProgramBuilder.addRuleInstance(ExtractUpdateExpressionsRule.INSTANCE);
        HepPlanner planner = new HepPlanner(hepProgramBuilder.build(), Contexts.empty(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(rel);
        return planner.findBestExp();
    }

    private static RelNode transformProjectAndFilterIntoCalc(RelNode rel) {
        HepProgramBuilder hepProgramBuilder = new HepProgramBuilder();
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_MERGE);
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_AGGREGATE_TRANSPOSE);
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_INTO_JOIN);
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_REDUCE_EXPRESSIONS);
        hepProgramBuilder.addRuleInstance(PruneEmptyRules.FILTER_INSTANCE);
        hepProgramBuilder.addRuleInstance(CoreRules.PROJECT_MERGE);
        hepProgramBuilder.addRuleInstance(CoreRules.PROJECT_REMOVE);
        hepProgramBuilder.addRuleInstance(PruneEmptyRules.PROJECT_INSTANCE);
        hepProgramBuilder.addRuleInstance(CoreRules.JOIN_REDUCE_EXPRESSIONS);
        hepProgramBuilder.addRuleInstance(CoreRules.JOIN_PROJECT_RIGHT_TRANSPOSE_INCLUDE_OUTER);
        hepProgramBuilder.addRuleInstance(CoreRules.PROJECT_TO_CALC);
        hepProgramBuilder.addRuleInstance(CoreRules.FILTER_TO_CALC);
        hepProgramBuilder.addRuleInstance(CalcMergeRule.INSTANCE);
        hepProgramBuilder.addRuleInstance(CoreRules.CALC_REMOVE);
        HepPlanner planner = new HepPlanner(hepProgramBuilder.build(), Contexts.empty(), true, null, RelOptCostImpl.FACTORY);
        planner.setRoot(rel);
        return planner.findBestExp();
    }

    private static boolean hasNestedExists(RelNode root) {
        class NestedExistsFinder
        extends RelVisitor {
            private boolean found;
            private int depth;
            final /* synthetic */ RelNode val$root;

            NestedExistsFinder(RelNode relNode) {
                this.val$root = relNode;
            }

            @Override
            public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                RexSubQuery exists;
                if (node instanceof LogicalFilter && (exists = this.getExists((LogicalFilter)node)) != null) {
                    this.found |= this.depth > 0;
                    ++this.depth;
                    this.go(exists.rel);
                    --this.depth;
                }
                super.visit(node, ordinal, parent);
            }

            private boolean find() {
                this.go(this.val$root);
                return this.found;
            }

            private RexSubQuery getExists(LogicalFilter filter) {
                final RexSubQuery[] existsSubQuery = new RexSubQuery[]{null};
                filter.getCondition().accept(new RexVisitorImpl<Void>(true){

                    @Override
                    public Void visitSubQuery(RexSubQuery subQuery) {
                        if (subQuery.getKind() == SqlKind.EXISTS) {
                            existsSubQuery[0] = subQuery;
                        }
                        return (Void)super.visitSubQuery(subQuery);
                    }
                });
                return existsSubQuery[0];
            }
        }
        return new NestedExistsFinder(root).find();
    }
}

